#!/usr/bin/env python
#

# read coefficients file from logistic regression and print Java
# equation for computing similarity.

import sys, string, re

BASIC_FEATURES = [
    'AnglePerDistance',
    'Aspect',
    'BoundsAngle',
    'BoundsSize',
    'Curviness',
    'Curviness2',
    'Density1',
    'Density2',
    'EndsAngleCosine',
    'EndsAngleSine',
    'EndsDistance',
    'InitAngleCosine',
    'InitAngleSine',
    'LogArea',
    'LogAspect',
    'Sharpness',
    'TotalAbsAngle',
    'TotalAngle',
    'TotalLength'
    ]

PAIR_FUNCTIONS = """
  public static double absDiff(Class featureClass, GestureObject g1, GestureObject g2)
  {
    double v1 = FeatureFactory.getFeatureValue(featureClass, g1);
    double v2 = FeatureFactory.getFeatureValue(featureClass, g2);
    return Math.abs(v1 - v2);
  }
  
  public static double absDiffFraction(Class featureClass, GestureObject g1, GestureObject g2)
  {
    double v1 = FeatureFactory.getFeatureValue(featureClass, g1);
    double v2 = FeatureFactory.getFeatureValue(featureClass, g2);
    double sum = v1 + v2;
    if (sum == 0) {
      return 0;
    }
    else {
      return 2 * Math.abs(v1-v2) / sum;
    }
  }
  
  public static double logAbsDiff(Class featureClass, GestureObject g1, GestureObject g2)
  {
    return Math.log(1 + absDiff(featureClass, g1, g2));
  }"""

PAIR_FEATURES = [
    'absDiff',
    'absDiffFraction',
    'logAbsDiff'
    ]

NAME_REGEX = re.compile('PF(?P<pair>[1-9])F(?P<feature>[1-9][0-9]?)')

def makeFeatureValue(pairIndex, featureIndex):
    featureClass = BASIC_FEATURES[featureIndex]
    # todo

CLASS_HEADER = """import edu.berkeley.guir.gesture.FeatureFactory;
import edu.berkeley.guir.gesture.GestureObject;
import edu.berkeley.guir.gesture.features.*;

/** Determines if two gestures are very similar to a person.  Based on
    a web survey done in Aug-Sep 2000 where people ranked the
    similarity of pairs of gestures.  The equation is a result of
    logistic regression on the survey data. <p> <strong>NOTE</strong>
    This file was generated by make-similarity-equation.py and should
    not be hand edited. */
public class HumanSimilarity {
  private HumanSimilarity() {}"""

METHOD_HEADER = """
  /** return whether g1 and g2 will be perceived by people as being very
      similar */
  public static boolean areVerySimilar(GestureObject g1, GestureObject g2)
  {
    double predictor;

    predictor ="""

FOOTER = """      ;
    return predictor >= 0.5;
  }
}"""

def printStart():
    print CLASS_HEADER
    print PAIR_FUNCTIONS
    print METHOD_HEADER

def printEnd():
    print FOOTER

def printTerm(c, pairIndex, featureIndex):
    print '      + %f * %s(%s.class, g1, g2)' % \
          (c, PAIR_FEATURES[pairIndex], \
           BASIC_FEATURES[featureIndex])
    
######################################################################
# main
#

fileNames = sys.argv[1:]

printStart()

for fileName in fileNames:
    file = open(fileName)
    while 1:
        line = file.readline()
        if not line:
            break
        fields = string.split(line)
        if fields[0] == 'Constant':
            print '      + %s' % fields[1]
        else:
            match = NAME_REGEX.match(fields[0])
            (pairIndex, featureIndex) = \
                        map(string.atoi,match.group('pair', 'feature'))
            c = string.atof(fields[1])
            printTerm(c, pairIndex-1, featureIndex-1)

printEnd()
