from java.lang import *
from java.awt import *
from java.io import *
from javax.swing import *
from edu.berkeley.guir.gesture import GestureSetDisplay, GestureSetFrame
import re

def loadGestureSet(filename):
	gsFrame = GestureSetFrame('loading', 0)
	gsFrame.openFile(File(filename))
	return gsFrame.getGestureSetDisplay().getGestureSet()

gestureSet = loadGestureSet('/n/vid13/allanl/working/newswing/gesture/data/memorability-case1.gsa')

f = JFrame('test')
c = f.getContentPane()
c.setLayout(BorderLayout())

gsDisplay = GestureSetDisplay(gestureSet, 0)
scroller = JScrollPane(gsDisplay)
scroller.setMinimumSize(Dimension(0, 0))
scroller.setPreferredSize(Dimension(895,1075))
gsDisplay.setScroller(scroller)

c.add(scroller, BorderLayout.CENTER)

f.pack()
f.show()

def splitFile(name):
	lines = open(name).readlines()
	return splitText(lines)

def splitText(lines):
	sections = []
	section = []
	for line in lines:
		if (re.search(">", line)):
			section.append(line)
		else:
			if (section != []):
				sections.append(section)
				section = []
	if (section != []): sections.append(section)
	return sections

execfile('/n/vid13/allanl/working/newswing/gesture/src/apps/memorability/MatchPanel.py')
execfile('/n/vid13/allanl/working/newswing/gesture/src/apps/memorability/MatchFrame.py')

sections = splitFile('/n/vid13/allanl/working/mine/experiments/memorability/data/7.txt')
inputSet = loadGestureSet('/n/vid13/allanl/working/mine/experiments/memorability/data/7-1_7-23.gsa')
matchFrame = MatchFrame(gsDisplay.getGestureSet(), inputSet, sections[1])
matchFrame.pack()
matchFrame.show()

def selectionHandler(e):
	if (e.getStateChange() == e.SELECTED):
		p = matchFrame.matchesPanel.selectedPanel
		p.setCategory(e.getItem().getGestureCategory())
		matchFrame.pack()

gsDisplay.itemStateChanged.append(selectionHandler)

