#!/usr/bin/env jpython

import time, os, sys, re, string

def splitFile(name):
	lines = open(name).readlines()
	return splitText(lines)

def splitText(lines):
	sections = []
	section = []
	for line in lines:
		if (re.search(">", line)):
			section.append(line)
		else:
			if (section != []):
				sections.append(section)
				section = []
	if (section != []): sections.append(section)
	return sections

for i in sys.argv[1:]:
	out = string.split(i,'.')[0]
	sections = splitFile(i)
	if (len(sections) >= 2):
		out = out + "\t" + len(sections[1]).toString()
	if (len(sections) >= 3):
		out = out + "\t" + string.count(string.join(sections[2]), "\tCORRECT").toString()
	if (len(sections) >= 4):
		out = out + "\t" + string.count(string.join(sections[3]), "\tCORRECT").toString()
	if (len(sections) >= 5):
		out = out + "\t" + len(sections[4]).toString()
	print out
