#!/usr/bin/env python

# summarize the test results
# - time
# - # of trials
# - % correct

import re, sys, string

LOG_FILE_REGEX = re.compile("(?P<month>\d+)/(?P<day>\d+)>(?P<hour>\d+):(?P<minute>\d+):(?P<second>\d+)\t(?P<name>.+)\t(?P<correct>.*CORRECT)")

def computeSecondsHMS(hours, minutes, seconds):
    return ((hours * 60) + minutes) * 60 + seconds

def computeSeconds(t):
    (h, m, s) = t
    return computeSecondsHMS(h, m, s)

def diffTimes(time1, time2):
    "time1 - time2 (seconds)"
    return computeSeconds(time1) - computeSeconds(time2)

printfile = len(sys.argv) > 2

for file in sys.argv[1:]:
    lines = open(file).readlines()
    startTime = None
    numCorrect = 0
    count = 0
    for line in lines:
	match = LOG_FILE_REGEX.match(line)
	if match:
	    time = computeSeconds(map(string.atoi, match.group('hour','minute','second')))
	    if startTime == None:
		startTime = time
	    correct = match.group('correct')
	    if correct == 'CORRECT':
		numCorrect = numCorrect + 1
	    count = count + 1
	else:
	    print '!MATCH:\t' + line
    percent = 100.0 * numCorrect / count # coerce to float
    if printfile:
	name = file + ':\t'
    else:
	name = ''
    print '%s%d\t%d\t%f' % (name, time - startTime, count, percent)
