#!/usr/bin/env python

# make summary of iconicness data from survey results
# data input format:
#
# iconicness_g#,i
#
# where g# is the gesture number and i is the iconicness (1-5, 5 is
# most iconic (i.e., best))
#
# looks up names of gestures in plain text files called names-{1,2,3}.txt.
#
# output is 

import re, sys, string, os

progName = os.path.basename(sys.argv[0])
USAGE = '%s: usage: %s nameDir iconicnessFile1 [iconicnessFile2 ...]\n' % (progName, progName)

ICONICNESS_FILE_REGEX = re.compile("iconicness_(?P<gestureNum>\d+),(?P<iconicness>[1-5])")
TXT_FILE_REGEX = re.compile("(?P<prefix>.*/)?(?P<pid>\d+)(?P<rest>.*).txt")

if len(sys.argv) < 3:
    sys.stderr.write(USAGE)
    sys.exit(-1)

nameDir = sys.argv[1]
inFiles = sys.argv[2:]

def pidToCase(pidStr):
    pid = string.atoi(pidStr)
    if pid < 100:
        return (pid - 1) % 3 + 1
    else:
        return (pid - 1) % 2 + 1

gestureNames = []
for i in [1,2,3]:
    fileName = '%s/names-%d.txt' % (nameDir, i)
    try:
        file = open(fileName)
    except:
        traceback.print_exc(file=sys.stdout)
        sys.stderr.write('%s: error reading required file "%s".' % (progName, fileName))
        sys.exit(-2)
        
    nameList = map(string.strip, file.readlines()) 
    gestureNames.append(nameList)

results = {}

for inFileName in inFiles:
    inFile = open(inFileName)
    fileNameMatch = TXT_FILE_REGEX.match(inFileName)
    pid = fileNameMatch.group('pid')
    case = pidToCase(pid)-1
    lineResults = {}
    for line in inFile.readlines():
        match = ICONICNESS_FILE_REGEX.match(line)
        if match:
            (gestureNum, iconicness) = map(string.atoi,
                                           match.group('gestureNum', 'iconicness'))
            lineResults[gestureNames[case][gestureNum-1]] = iconicness
    results[pid] = lineResults

# print header
sortedNames = gestureNames[0]
sortedNames.sort()
for name in sortedNames:
    print '\t%s' % name,
print

pids = results.keys()
pids.sort()
for pid in pids:
    print pid,
    lineResults = results[pid]
    for gName in sortedNames:
        if lineResults.has_key(gName):
            iconicness = '%d' % lineResults[gName]
        else:
            sys.stderr.write('%s: error: gesture "%s" not found for participant "%s"\n' % (progName, gName, pid))
            iconicness = ''
        print '\t%s' % iconicness,
    print
