#!/usr/bin/env jpython

import sys, re, os, os.path, string

def splitFile(name):
	lines = open(name).readlines()
	return splitText(lines)

def splitText(lines):
	sections = []
	section = []
	for line in lines:
		if (re.search(">", line)):
			section.append(line)
		else:
			if (section != []):
				sections.append(section)
				section = []
	if (section != []): sections.append(section)
	return sections

for oldName in sys.argv[1:]:
	sections = splitFile(oldName)
	baseName = string.replace(os.path.basename(oldName), '.txt', '')
	for i in range(len(sections)):
		newName = "%s-%d.txt" % (baseName, i)
		f = open(newName, 'w')
		for j in range(len(sections[i])):
			f.write(sections[i][j])
		f.close()
