#!/usr/bin/env jpython

import re, os, string, sys

TXT_FILE_REGEX = re.compile("(?P<prefix>.*/)?(?P<pid>\d+)(?P<rest>.*).txt")
def canonicalName(name):
	match = TXT_FILE_REGEX.match(name)
	(prefix, rest) = match.group('prefix', 'rest')
	if prefix == None:
		prefix = ""
	pid = string.atoi(match.group('pid'))
	return "%s%03d%s.txt" % (prefix, pid, rest)

for old in sys.argv[1:]:
	newName = canonicalName(old)
	if os.path.exists(newName):
		print sys.argv[0] + ": error: '" + newName + "' exists"
	else:
		os.rename(old, newName)
