#!/usr/bin/env jpython

import re, os, string, sys

GS_FILE_REGEX = re.compile("(?P<prefix>.*/)?(?P<pid>\d+)-(?P<trial>\d)_(?P<month>\d+)-(?P<day>\d+).gsa")
def canonicalName(name):
	match = GS_FILE_REGEX.match(name)
	prefix = match.group('prefix')
	(pid, trial, month, day) = map(string.atoi, match.group('pid', 'trial', 'month', 'day'))
	return "%s%03d-%d_%02d-%02d" % (prefix, pid, trial, month, day)

for old in sys.argv[1:]:
	newName = canonicalName(old)
	if os.path.exists(newName):
		print sys.argv[0] + ": error: '" + newName + "' exists"
	else:
		os.rename(old, newName)
