#!/usr/bin/env python

# Summarize by participant
#

import sys, string, os, posixpath

progName = sys.argv[0]
usage = '%s: usage: %s phaselog [phaselog2 [phaselog3 ...]]' % (progName, progName)
if len(sys.argv) == 1:
    print usage
fileNames = sys.argv[1:]

# group files based on participant.  Return a dictionary of phase
# lists keyed by participant (phase as int, participant as string)
def groupFileNames(names):
    groups = {}
    for name in names:
	(base, ext) = string.split(name, '.')
	(participant, phase) = string.split(base, '-')
	phase = string.atoi(phase)
	if groups.has_key(participant):
	    groups[participant].append(phase)
	else:
	    groups[participant] = [ phase ]
    return groups

groups = groupFileNames(fileNames)

participants = groups.keys()
participants.sort()

for participant in participants:
    print participant,
    for phase in [1,2,3,4]:
	fileName = '%s-%d.txt' % (participant, phase)
	if posixpath.exists(fileName):
	    summary = os.popen('summary.py %s' % fileName)
	    stats = string.strip(summary.readline())
	    summary.close()
	else:
	    stats = '\t\t'
	print '\t' + stats,
    print
