#!/usr/bin/env python

# Take a table whose column headers are gesture names and whose row
# headers are pids, and change it so it uses gesture indices instead of
# names.
#

import re, sys, string, os

progName = os.path.basename(sys.argv[0])
USAGE = '%s: usage: %s numbering table\n' % (progName, progName)

if len(sys.argv) != 3:
    sys.stderr.write(USAGE)
    sys.exit(-1)

numberingFileName = sys.argv[1]
tableFileName = sys.argv[2]

def readNumbering(fileName):
    "returns a list of dictionaries, one for each case, keyed by gesture name, whose values are the indices"
    file = open(fileName)
    gNames = map(string.strip, string.split(string.strip(file.readline()), '\t'))
    lines = file.readlines()
    result = []
    for line in lines:
        dict = {}
        indices = map(string.atoi, string.split(string.strip(line), '\t')[1:])
        for i in range(len(indices)):
            dict[gNames[i]] = indices[i]
        result.append(dict)
    return result

def pidToCase(pidStr):
    pid = string.atoi(pidStr)
    if pid < 100:
        return (pid - 1) % 3 + 1
    else:
        return (pid - 1) % 2 + 1

numbering = readNumbering(numberingFileName)

gestureNameOrder = []
for num in numbering:
    names = num.keys()
    names.sort(lambda x, y: cmp(num[x], num[y]))
    gestureNameOrder.append(names)

tableFile = open(tableFileName)

gNames = map(string.strip,string.split(string.strip(tableFile.readline()), '\t'))

indexRange = range(len(gNames))
print '\t' + string.joinfields(map(lambda x: '%s' % x, indexRange), '\t')

for line in tableFile.readlines():
    fields = string.split(line, '\t')
    pid = fields[0]
    case = pidToCase(pid)
    data = fields[1:]
    lineData = {}
    print pid,
    for name in gestureNameOrder[case - 1]:
        value = string.strip(data[gNames.index(name)])
        print '\t%s' % value,
    print

