#!/usr/bin/env jpython

# print out the gesture names and their indices
#

from edu.berkeley.guir.gesture import GestureSetFrame, GestureSet, GestureSetDisplay, GestureDisplay
from java.io import File
import re, sys, string, os

progName = os.path.basename(sys.argv[0])
USAGE = '%s: usage: %s gestureSet1.gsa [gestureSet2.gsa ...]\n' % (progName, progName)

def loadGestureSet(filename):
    gsFrame = GestureSetFrame('loading', 0)
    gsFrame.openFile(File(filename))
    return gsFrame.getGestureSetDisplay().getGestureSet()

if len(sys.argv) == 1:
    sys.stderr.write(USAGE)
    sys.exit(-1)

sys.stderr.write('reading gesture sets...\n')
result = {}
for fileName in sys.argv[1:]:
    gestureSet = loadGestureSet(fileName)
    fileResult = {}
    for i in range(gestureSet.size()):
	category = gestureSet.categoryAt(i)
	fileResult[category.getName()] = i
    result[fileName] = fileResult

gestureNames = result[sys.argv[1]].keys()
gestureNames.sort()

sys.stderr.write('outputting results...\n')

for gesture in gestureNames:
    print '\t%s' % gesture,
print

# print results
for fileName in sys.argv[1:]:
    sys.stderr.write('file: %s\n' % fileName)
    print fileName,
    fileResult = result[fileName]
    for gesture in gestureNames:
	sys.stderr.write('\tgesture: %s\n' % gesture)
	if fileResult.has_key(gesture):
	    out = "\t%d" % fileResult[gesture]
	else:
	    out = "\t"
	print out,

sys.stderr.write('Done!\n')
