from edu.berkeley.guir.gesture import GestureSetFrame, GestureSet, GestureSetDisplay, GestureDisplay, Gesture, GesturePointsDisplay
from java.io import *
from java.lang import *
from java.awt import *
from javax.swing import *

class MatchPanel(JPanel):
	"panel for a single gesture"

	def __init__(self, desiredName, drawing, gestureSet):
		"""Drawing is the Gesture the participant drew.
		gestureSet is the set being learned."""
		JPanel.__init__(self, BorderLayout())
		self.gestureSet = gestureSet
		# first do the part that chooses the gesture
		gesturePanel = JPanel()
		drawing.normalize()
		self.drawnGesture = drawing
		self.desiredName = desiredName

		drawnDisplay = GestureDisplay(self.drawnGesture)
		drawnDisplay.setOffset(5, 5);
		drawnDisplay.setBorder(BorderFactory.createLoweredBevelBorder())
		gesturePanel.add(drawnDisplay)
		self.selectedGestureDisplay = GestureDisplay()
		self.selectedGestureDisplay.setOffset(5, 5);
		self.selectedGestureDisplay.setBorder(BorderFactory.createLoweredBevelBorder())
		gesturePanel.add(self.selectedGestureDisplay)
		self.add(gesturePanel, BorderLayout.WEST)
		choicePanel = Box.createVerticalBox()
		self.categorySelected = ''

		# now do the part that chooses other stuff
		rotationPanel = JPanel()
		rotationPanel.add(JLabel('Rotation:'))
		self.rotationField = JTextField('0')
		self.rotationField.setColumns(5);
		rotationPanel.add(self.rotationField)
		choicePanel.add(rotationPanel)
		self.isHorizontalFlipped = JCheckBox('Horizontal flip')
		choicePanel.add(self.isHorizontalFlipped)
		self.isVerticalFlipped = JCheckBox('Vertical flip')
		choicePanel.add(self.isVerticalFlipped)
		self.isBackwards = JCheckBox('Backwards')
		choicePanel.add(self.isBackwards)
		choicePanel.add(Box.createVerticalGlue())
		self.add(choicePanel, BorderLayout.EAST)

		radioPanel = JPanel()
		radioPanel.setLayout(BoxLayout(radioPanel,BoxLayout.Y_AXIS))
		radioPanel.setBorder(BorderFactory.createEtchedBorder())
		self.isDot = JRadioButton('Is a dot', actionPerformed = lambda e, gd=self.selectedGestureDisplay: gd.setGesture(None))
		radioPanel.add(self.isDot)

		self.isBlank = JRadioButton('Is blank', actionPerformed = lambda e, gd=self.selectedGestureDisplay: gd.setGesture(None))
		radioPanel.add(self.isBlank)

		self.isReal = JRadioButton('dummy')

		self.buttonGroup = ButtonGroup()
		self.buttonGroup.add(self.isDot)
		self.buttonGroup.add(self.isBlank)
		self.buttonGroup.add(self.isReal)

		choicePanel.add(radioPanel)

		self.setBorder(BorderFactory.createEtchedBorder())

	def getDesiredName():
		return self.desiredName
	def setCategory(self, gestureCategory):
		self.categorySelected = gestureCategory
		self.selectedGestureDisplay.setGesture(gestureCategory.gestureAt(0))
		self.buttonGroup.setSelected(self.isReal.getModel(), 1)
	def getCategory(self):
		return self.categorySelected
	def getCatIndex(self):
		return self.gestureSet.indexOf(self.categorySelected)
	def getRotation(self):
		return int(self.rotationField.getText())
	def isHorizFlipped(self):
		return self.isHorizontalFlipped.isSelected()
	def isVertFlipped(self):
		return self.isVerticalFlipped.isSelected()
	def isBackwards(self):
		return self.isBackwards.isSelected()
	def isDot(self):
		return self.isDot.isSelected()
	def isBlank(self):
		return self.isBlank.isSelected()
	def isReal(self):
		return self.isReal.isSelected()
	def getHeader(self):
		return "Desired Name\tDrawn Index\tDrawn Name\tRotation\tIs Horiz Flipped\tIs Vert Flipped\tIs Backwards"
	def toString(self):
		if self.isReal():
			return "%s\t%d\t%s\t%d\t%d\t%d\t%d" % \
			       (self.getDesiredName(), self.getCatIndex(),
				self.getCategory().getName(),
				self.getRotation(), self.isHorizFlipped(),
				self.isVertFlipped(), self.isBackwards())
		elif self.isBlank():
			return "%s\t-1\tBLANK" % self.getDesiredName()
		elif self.isDot():
			return "%s\t-2\tDOT" % self.getDesiredName()
		else:
			return "%s\t-3\tBOGUS" % self.getDesiredName()

class MyGesture(Gesture):
	def __init__(self):
		Gesture.__init__(self)
	
class ScalableGPDisplay(GesturePointsDisplay):
	def __init__(self, scale):
		print self
		print self.getClass()
		print self.getClass().getSuperclass()

		GesturePointsDisplay.__init__(self)
		self.scale = scale

	def getPreferredSize(self):
		d = GesturePointsDisplay.getPreferredSize()
		return Dimension(int(d.width*self.scale), int(d.height*self.scale))

	def paint(self, graphics):
		g = graphics.create()
		g.scale(self.scale, self.scale)
		GesturePointsDisplay.paint(g)
		g.dispose()

print 'java...'
g = Gesture()
#sgp = ScalableGPDisplay(1.0)
print 'python...'
mg = MyGesture()
print 'done'
import sys
sys.exit(0)
