#!/usr/bin/env python

# create confusion matrix out of cm files
#
import sys, string

def incrKey(dict, key):
    if dict.has_key(key):
	dict[key] = dict[key] + 1
    else:
	dict[key] = 1

def appendUniquely(l, item):
    if not item in l:
	l.append(item)

nameMatrix = {}

allKeys = []

for fileName in sys.argv[1:]:
    file = open(fileName)
    lines = file.readlines()
    for line in lines:
	fields = string.split(string.strip(line), '\t')
	(name, time, correct) = fields[:3]
	appendUniquely(allKeys,name)
	if nameMatrix.has_key(name):
	    confusions = nameMatrix[name]
	else:
	    confusions = {}
	    nameMatrix[name] = confusions
	if correct == '1':
	    key = name
	else:
	    key = fields[4]
	    appendUniquely(allKeys,key)
	incrKey(confusions, key)

allKeys.sort()

for key in allKeys:
    print '\t' + key,
print

validKeys = nameMatrix.keys()
validKeys.sort()
for xname in validKeys:
    print xname,
    counts = nameMatrix[xname]
    for yname in allKeys:
	if counts.has_key(yname):
	    count = counts[yname]
	else:
	    count = 0
	print '\t%d' % count,
    print
