#!/usr/bin/env python

# separte confusion data into two kinds:
#
# 1. "bad hits": Gi is drawn instead of Gj
# 2. "misses": Gi was not drawn when it should have been
#
# input is text confusion log (*-cm.txt)
#
# output is a file with bad hits followed by misses
#

import sys, string, re, getopt



DATA_FILE_REGEX = re.compile("(?P<prefix>.*/)?(?P<pid>\d+)-(?P<phase>\d)_(?P<month>\d+)-(?P<day>\d+)(?P<rest>.*)")

# indexed by pid, contains hash of # of bad hits, indexed by gesture name
badHits = {}
# indexed by pid, contains hash of # of misses, indexed by gesture name
misses = {}
gestureNames = []

optlist, args = getopt.getopt(sys.argv[1:], 'e:')

if len(args) == 0:
    sys.stderr.write(USAGE)
    sys.exit(-1)

for (option, arg) in optlist:
    if option == '-e':
        exclusions = string.split(arg)

def incrKey(dict, key):
    if dict.has_key(key):
	dict[key] = dict[key] + 1
    else:
	dict[key] = 1

def appendUniquely(l, item):
    if not item in l:
	l.append(item)

def printHeader(l):
    for item in l:
	print '\t%s' % item,
    print

def printTable(gNames, dict):
    printHeader(gNames)
    keys = dict.keys()
    keys.sort()
    for k in keys:
	print k,
	row = dict[k]
	for gesture in gNames:
	    if row.has_key(gesture):
		value = row[gesture]
	    else:
		value = 0
	    print '\t%s' % value,
	print

for fileName in args:
    file = open(fileName)
    match = DATA_FILE_REGEX.match(fileName)
    pid = match.group('pid')
    if pid not in exclusions:
        lines = file.readlines()
        if badHits.has_key(pid):
            pBadHits = badHits[pid]
            pMisses = misses[pid]
        else:
            pBadHits = {}
            pMisses = {}
            badHits[pid] = pBadHits
            misses[pid] = pMisses
        for line in lines:
            fields = string.split(string.strip(line), '\t')
            (name, time, correct) = fields[:3]
            appendUniquely(gestureNames, name)
            if correct == '0':
                actual = fields[4]
                incrKey(pMisses, name)
                incrKey(pBadHits, actual)

gestureNames.sort()

# print bad hits
print 'Bad hits:'
printTable(gestureNames, badHits)

print

# print misses
print 'Misses'
printTable(gestureNames, misses)

    
