#!/usr/bin/env python

# combine test results (from 001.txt, 002.txt, etc.) into one file of
# the format
#
# 	g1	g2	g3	...
# S1	c11	c12	c13	...
# S2	c21	c22	c23	...
# ...
#
# Where gs are gestures, Ss are participants, and cs are 0 or 1 for
# correct or incorrect.  gs are sorted alphabetically.

import re, sys, string

LOG_FILE_REGEX = re.compile("(?P<month>\d+)/(?P<day>\d+)>(?P<hour>\d+):(?P<minute>\d+):(?P<second>\d+)\t(?P<name>.+)\t(?P<correct>.*CORRECT)")
TXT_FILE_REGEX = re.compile("(?P<prefix>.*/)?(?P<pid>\d+)(?P<rest>.*).txt")

result = {}
for file in sys.argv[1:]:
    lines = open(file).readlines()
    fileMatch = TXT_FILE_REGEX.match(file)
    pid = fileMatch.group('pid')
    pidResult = {}
    for line in lines:
        lineMatch = LOG_FILE_REGEX.match(line)
        (gesture, correct) = lineMatch.group('name', 'correct')
        if correct == 'CORRECT':
            correctVal = 1
        else:
            correctVal = 0
        pidResult[gesture] = correctVal
    result[pid] = pidResult

gNames = result[result.keys()[0]].keys()
gNames.sort()
# print header
for gName in gNames:
    print '\t%s' % gName,
print

pids = result.keys()
pids.sort()

for pid in pids:
    print pid,
    pidResult = result[pid]
    gestures = pidResult.keys()
    gestures.sort()
    for gesture in gestures:
        print '\t%d' % pidResult[gesture],
    print

