import string, re, os
from os import os.path

DATA_FILE_REGEX = re.compile("(?P<prefix>.*/)?(?P<pid>\d+)-(?P<phase>\d)_(?P<month>\d+)-(?P<day>\d+)(?P<rest>.*)")

def whichCase(filename):
	match = DATA_FILE_REGEX.match(filename)
	pid = string.atoi(match.group('pid'))
	if pid < 100:
		return (pid - 1) % 3 + 1
	else:
		return (pid -1 ) % 2 + 1

names = map(string.strip, os.popen('ls ../trials/*-cm.txt').readlines())

for f in names:
 	case = whichCase(f)
 	base = os.path.basename(f)
 	os.symlink('../' + f, '%d/%s' % (case, base))
 
