#!/usr/bin/env python

import string, sys, re

PID_REGEX = re.compile("(?P<prefix>.*/)?(?P<pid>\d+).*")
def getPid(str):
    match = PID_REGEX.match(str)
    return match.group('pid')
    
def pidToCase(pidStr):
    pid = string.atoi(pidStr)
    if pid < 100:
        return (pid - 1) % 3 + 1
    else:
        return (pid - 1) % 2 + 1

cases = map(pidToCase, map(getPid, sys.stdin.readlines()))

count = [0, 0, 0]
for c in cases:
    count[c-1] = count[c-1]+1

print count
