from java.lang import *
from java.awt import *
from java.io import *
from javax.swing import *
from edu.berkeley.guir.gesture import GestureSetDisplay, GestureSetFrame, GestureDisplay

# panel for a single gesture
class MatchPanel(JPanel):

	# drawing is the Gesture the participant drew
	# gestureSet is the set being learned
	def __init__(self, drawing, gestureSet):
		JPanel.__init__(self, BorderLayout())
		self.gestureSet = gestureSet
		# first do the part that chooses the gesture
		gesturePanel = JPanel()
		drawing.normalize()
		self.drawnGesture = drawing

		drawnDisplay = GestureDisplay(self.drawnGesture)
		drawnDisplay.setOffset(5, 5);
		drawnDisplay.setBorder(BorderFactory.createLoweredBevelBorder())
		gesturePanel.add(drawnDisplay)
		self.selectedGestureDisplay = GestureDisplay()
		self.selectedGestureDisplay.setOffset(5, 5);
		self.selectedGestureDisplay.setBorder(BorderFactory.createLoweredBevelBorder())
		gesturePanel.add(self.selectedGestureDisplay)
		self.add(gesturePanel, BorderLayout.WEST)
		choicePanel = Box.createVerticalBox()
		self.categorySelected = ''

		# now do the part that chooses other stuff
		rotationPanel = JPanel()
		rotationPanel.add(JLabel('Rotation:'))
		self.rotationField = JTextField('0')
		self.rotationField.setColumns(5);
		rotationPanel.add(self.rotationField)
		choicePanel.add(rotationPanel)
		self.isHorizontalFlipped = JCheckBox('Horizontal flip')
		choicePanel.add(self.isHorizontalFlipped)
		self.isVerticalFlipped = JCheckBox('Vertical flip')
		choicePanel.add(self.isVerticalFlipped)
		self.isBackwards = JCheckBox('Backwards')
		choicePanel.add(self.isBackwards)
		choicePanel.add(Box.createVerticalGlue())
		self.add(choicePanel, BorderLayout.EAST)

		self.setBorder(BorderFactory.createEtchedBorder())

	def setCategory(self, gestureCategory):
		self.categorySelected = gestureCategory
		self.selectedGestureDisplay.setGesture(gestureCategory.gestureAt(0))

	def getCategory(self):
		return self.categorySelected
	def getCatIndex(self):
		return self.gestureSet.indexOf(self.categorySelected)
	def getRotation(self):
		return int(self.rotationField.getText())
	def isHorizFlipped(self):
		return self.isHorizontalFlipped.isSelected()
	def isVertFlipped(self):
		return self.isVerticalFlipped.isSelected()
	def isBackwards(self):
		return self.isBackwards.isSelected()
