import re
from javax.swing import *
from java.awt import *
from edu.berkeley.guir.util import HystericResizer

# Frame holding a list of things to match
class MatchFrame(JFrame):
	# responses is a list of strings from the .txt file
	def __init__(self, stimuliSet, inputSet, responses):
		JFrame.__init__(self, 'Match gestures')
		self.matchesPanel = MatchesPanel(stimuliSet, inputSet, responses)
		scroller = JScrollPane(self.matchesPanel)
		scroller.setPreferredSize(Dimension(400,600))
		self.getContentPane().add(scroller)
		self.componentResized.append(lambda e, c=self.getRootPane(): c.setPreferredSize(c.getSize()))

class MatchesPanel(Box):
	# responses is a list of strings from the .txt file
	def __init__(self, stimuliSet, inputSet, responses):
		Box.__init__(self, BoxLayout.Y_AXIS)
		i = 0
		numGestures = inputSet.size()
		regex = re.compile(">.*\t(.+)\t(.*CORRECT)")
		def selector(e, container=self):
			newSelection = e.getComponent()
			oldSelection = container.selectedPanel
			if (oldSelection):
				oldSelection.setBorder(BorderFactory.createEtchedBorder())
				if (newSelection != oldSelection):
					newSelection.setBorder(BorderFactory.createLoweredBevelBorder())
					container.selectedPanel = newSelection
				else:
					container.selectedPanel = ''
			else:
				newSelection.setBorder(BorderFactory.createLoweredBevelBorder())
				container.selectedPanel = newSelection
		for response in responses:
			map = regex.search(response)
			if (map):
				(name, correct) = map.groups()
				if (correct == "INCORRECT"):
					g = inputSet.categoryAt(i).gestureAt(0)
					p = MatchPanel(g, stimuliSet)
					p.mouseClicked.append(selector)
					self.add(p)
				i = i + 1
				if (i >= numGestures):
					break
		self.selectedPanel = ''
