#!/usr/bin/env jpython
#
from edu.berkeley.guir.gesture import GestureFile, GesturePointsDisplay, \
     GestureCategory

from java.io import File, FileOutputStream, IOException
from java.awt import Dimension
from java.awt.image import BufferedImage
from com.keypoint import PngEncoder
from javax.swing import JFrame

import sys, os.path, re

progName = sys.argv[0]
usage = progName + ": usage: " + progName + " [-n|--use-numbers] [-p|--show-points] [-i|--index <index>] [-s|--scale <scale>] gesturefile\n"

import edu.berkeley.guir.gesture.GesturePointsDisplay
class ScalableGPDisplay(edu.berkeley.guir.gesture.GesturePointsDisplay):
    def __init__(self, scale):
        self.scale = scale

    def getPreferredSize(self):
        d = GesturePointsDisplay.getPreferredSize()
        return Dimension(int(d.width*self.scale), int(d.height*self.scale))

    def paint(self, graphics):
        g = graphics.create()
        g.scale(self.scale, self.scale)
        GesturePointsDisplay.paint(g)
        g.dispose()

    def setGesture(self, gesture):
        

def sanitizeName(catName):
    "Remove obnoxious characters like '/'"
    return re.sub('/', '_', catName)
    
def makeUniqueFileName(catName):
    name = '%s.png' % catName
    i = 0
    while os.path.exists(name):
        name = '%s-%d.png' % (catName, i)
        i = i+1
    return name

def handleGestureContainer(frame, pngEncoder, display, container,
                           index, fileName, useNumbers, gestures):
    for i in range(container.size()):
        child = container.getChild(i)
        if child == None:
            print 'Bogosity: null child'
#        print 'Child: %s\tclass: %s\tisGC: %s' % \
#              (child, child.getClass(), isinstance(child, GestureCategory))
        if isinstance(child, GestureCategory) and \
           (gestures == [] or child.getName in gestures):
            if (child.size() > 0):
                if useNumbers:

                    saneName = '%s-%03d' % (fileName, (index+1))
                else:
                    saneName = sanitizeName(child.getName())
                newFileName = makeUniqueFileName(saneName)
                gesture = child.getChild(0)
                gesture.normalize()
                display.setGesture(gesture)
                # have to pack() every time or the image is cropped :-(
                frame.pack()
                size = display.getPreferredSize()
                w = size.width
                h = size.height
                #image = BufferedImage(w, h, BufferedImage.TYPE_USHORT_565_RGB)
                image = display.createImage(w, h)
                display.paint(image.getGraphics())
                pngEncoder.setImage(image)
                pngBytes = pngEncoder.pngEncode()
#                print 'Writing output file "%s" (#%d)' % (newFileName,
#                                                          index)
                try:
                    outfile = FileOutputStream(newFileName)
                    try:
                        # todo: use try...except to catch errors
                        outfile.write(pngBytes)
                    except IOException, detail:
                        sys.stderr.write('%s: error: could not write output file "%s": %s\n' % (progName, newFileName, detail))
                    outfile.close()
                except IOException, detail:
                    sys.stderr.write('%s: error: could not open output file "%s": %s\n' % (progName, newFileName, detail))
                index = index+1
            else:
                sys.stderr.write('%s: warning: empty category "%s"\n' %
                                 (progName, child.getName()))
        else:
            index = handleGestureContainer(frame, pngEncoder, display,
                                           child, index, useNumbers,
                                           fileName)
    return index
    
def handleFiles(fileList, useNumbers, gestures, scale, showPoints):
    if scale == 1.0:
        display = GesturePointsDisplay()
    else:
        display = ScalableGPDisplay(scale)
    if showPoints:
        display.setShowPoints(1)
    pngEncoder = PngEncoder()
    frame = JFrame('gdptopng')
    frame.getContentPane().add(display)

    for fileName in fileList:
 #        print 'Reading file "%s"\n' % fileName
        f = GestureFile(File(fileName))
        try:
            f.read()
        except IOException, detail:
            sys.stderr.write('%s: error: could not read gesture file "%s": %s\n' % (progName, fileName, detail))
            continue
        gestureSet = f.getGesturePackage().getTrainingSet()
        # use name w/o directories, and strip off gesture-like extension
        baseName = re.sub('\.g[^.].*$', '', os.path.basename(fileName))
        handleGestureContainer(frame, pngEncoder, display, gestureSet, 0,
                               baseName, useNumbers, gestures)

def doError(errStr):
    sys.stderr.write("%s: error: %s\n" % (progName, errStr))
    sys.stderr.write(usage)
    sys.exit(-1)
    
numArgs = len(sys.argv)
if numArgs < 2:
    doError('wrong number of arguments')

import getopt

try:
    (options, files) = getopt.getopt(sys.argv[1:], 'ni:s:p',
                                     ['use-numbers', 'index=', 'scale=',
                                      '--show-points'])
except getopt.error, detail:
    doError(detail)

indices = []
gestures = []
scale = 1.0
showPoints = 0
useNumbers = 0
for (option, value) in options:
    o = option[1:]
    if o in ['n', '-use-numbers']:
        useNumbers = 1
    elif o in ['i', '-index']:
        indices.append(int(value))
    elif o in ['g', '-gesture']:
        gestures.append(value)
    elif o in ['s', '-scale']:
        scale = float(value)
    elif o in ['p', '-show-points']:
        showPoints = 1

handleFiles(files, useNumbers, gestures, scale, showPoints)

# we instantiated a JFrame, which started the AWT event thread, so we
# have to actually exit the interpreter to quit the program
sys.exit(0)
