#!/usr/bin/env jpython
#
# prints all feature values for all gesture categories in a package
#
from edu.berkeley.guir.gesture import GestureFile, GesturePointsDisplay, \
     GestureCategory, FeatureFactory
from edu.berkeley.guir.gesture.features import \
     AnglePerDistance, \
     Aspect, \
     BoundsAngle, \
     BoundsSize, \
     Curviness, \
     Curviness2, \
     Density1, \
     Density2, \
     EndsAngleCosine, \
     EndsAngleSine, \
     EndsDistance, \
     InitAngleCosine, \
     InitAngleSine, \
     LogArea, \
     LogAspect, \
     Sharpness, \
     TotalAbsAngle, \
     TotalAngle, \
     TotalLength

from java.io import File, FileOutputStream, IOException

import string, sys

FEATURES = [
    AnglePerDistance,
    Aspect,
    BoundsAngle,
    BoundsSize,
    Curviness,
    Curviness2,
    Density1,
    Density2,
    EndsAngleCosine,
    EndsAngleSine,
    EndsDistance,
    InitAngleCosine,
    InitAngleSine,
    LogArea,
    LogAspect,
    Sharpness,
    TotalAbsAngle,
    TotalAngle,
    TotalLength
    ]

def getName(featureClass):
    dummy = featureClass.newInstance()
    return dummy.getName()
    
def printHeader():
    print 'name',
    for name in map(getName,FEATURES):
        print '\t%s' % name,
    print

def processCategory(category):
    print category.getName(),
    for featureClass in FEATURES:
        print '\t%f' % FeatureFactory.getFeatureValue(featureClass, category),
    print
        
def processContainer(container):
    if isinstance(container, GestureCategory):
        processCategory(container)
    else:
        for child in container.getEnabledChildren():
            processContainer(child)
            

######################################################################
# main
#

fileNames = sys.argv[1:]

printHeader()

for fileName in fileNames:
    file = GestureFile(File(fileName))
    try:
        file.read()
    except IOException, detail:
        sys.stderr.write('%s: error: could not read gesture file "%s": %s\n' % (progName, fileName, detail))
        continue
    trainingSet = file.getGesturePackage().getTrainingSet()
    processContainer(trainingSet)
    
