#include <jni.h>
#include "edu_berkeley_guir_image_eztwain_EZTwainWrapper.h"
#include <eztwain.h>

/*
 * Class:     edu_berkeley_guir_image_eztwain_EZTwainWrapper
 * Method:    selectImageSource
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_edu_berkeley_guir_image_eztwain_EZTwainWrapper_selectImageSource
  (JNIEnv *env, jobject obj, jint hwnd)
{
	TWAIN_SelectImageSource ((HWND) hwnd);
}

/*
 * Class:     edu_berkeley_guir_image_eztwain_EZTwainWrapper
 * Method:    dibDepth
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_edu_berkeley_guir_image_eztwain_EZTwainWrapper_dibDepth
  (JNIEnv *env, jobject obj, jint handle)
{
	return DIB_Depth ((HANDLE) handle);
}

/*
 * Class:     edu_berkeley_guir_image_eztwain_EZTwainWrapper
 * Method:    acquireNative
 * Signature: (II)I
 */
JNIEXPORT jint JNICALL Java_edu_berkeley_guir_image_eztwain_EZTwainWrapper_acquireNative
  (JNIEnv *env, jobject obj, jint hwnd, jint pixTypes)
{
	return (jint) TWAIN_AcquireNative ((HWND) hwnd, pixTypes);
}

/*
 * Class:     edu_berkeley_guir_image_eztwain_EZTwainWrapper
 * Method:    dibHeight
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_edu_berkeley_guir_image_eztwain_EZTwainWrapper_dibHeight
  (JNIEnv *env, jobject obj, jint handle)
{
	return DIB_Height ((HANDLE) handle);
}

/*
 * Class:     edu_berkeley_guir_image_eztwain_EZTwainWrapper
 * Method:    dibReadRowRGB
 * Signature: (II[B)V
 */
JNIEXPORT void JNICALL Java_edu_berkeley_guir_image_eztwain_EZTwainWrapper_dibReadRowRGB
  (JNIEnv *env, jobject obj, jint handle, jint row, jbyteArray buf)
{
	jbyte *bufbody = env->GetByteArrayElements (buf, 0);

	DIB_ReadRowRGB ((HANDLE) handle, row, (BYTE *) bufbody);

	env->ReleaseByteArrayElements (buf, bufbody, 0);
}

/*
 * Class:     edu_berkeley_guir_image_eztwain_EZTwainWrapper
 * Method:    dibWidth
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_edu_berkeley_guir_image_eztwain_EZTwainWrapper_dibWidth
  (JNIEnv *env, jobject obj, jint handle)
{
	return DIB_Width ((HANDLE) handle);
}

/*
 * Class:     edu_berkeley_guir_image_eztwain_EZTwainWrapper
 * Method:    freeNative
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_edu_berkeley_guir_image_eztwain_EZTwainWrapper_freeNative
  (JNIEnv *env, jobject obj, jint handle)
{
	TWAIN_FreeNative ((HANDLE) handle);
}

/*
 * Class:     edu_berkeley_guir_image_eztwain_EZTwainWrapper
 * Method:    disableSource
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_edu_berkeley_guir_image_eztwain_EZTwainWrapper_disableSource
  (JNIEnv *env, jobject obj)
{
	return (jint) TWAIN_DisableSource ();
}

/*
 * Class:     edu_berkeley_guir_image_eztwain_EZTwainWrapper
 * Method:    enableSource
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_edu_berkeley_guir_image_eztwain_EZTwainWrapper_enableSource
  (JNIEnv *env, jobject obj, jint hwnd)
{
	return (jint) TWAIN_EnableSource ((HWND) hwnd);
}

/*
 * Class:     edu_berkeley_guir_image_eztwain_EZTwainWrapper
 * Method:    getMultiTransfer
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_edu_berkeley_guir_image_eztwain_EZTwainWrapper_getMultiTransfer
  (JNIEnv *env, jobject obj)
{
	return (jint) TWAIN_GetMultiTransfer ();
}

/*
 * Class:     edu_berkeley_guir_image_eztwain_EZTwainWrapper
 * Method:    getState
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_edu_berkeley_guir_image_eztwain_EZTwainWrapper_getState
  (JNIEnv *env, jobject obj)
{
	return (jint) TWAIN_State ();
}

/*
 * Class:     edu_berkeley_guir_image_eztwain_EZTwainWrapper
 * Method:    setMultiTransfer
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_edu_berkeley_guir_image_eztwain_EZTwainWrapper_setMultiTransfer
  (JNIEnv *env, jobject obj, jint val)
{
	TWAIN_SetMultiTransfer ((int) val);
}

/*
 * Class:     edu_berkeley_guir_image_eztwain_EZTwainWrapper
 * Method:    unloadSourceManager
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_edu_berkeley_guir_image_eztwain_EZTwainWrapper_unloadSourceManager
  (JNIEnv *env, jobject obj)
{
	return (jint) TWAIN_UnloadSourceManager ();
}

/*
 * Class:     edu_berkeley_guir_image_eztwain_EZTwainWrapper
 * Method:    closeSource
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_edu_berkeley_guir_image_eztwain_EZTwainWrapper_closeSource
  (JNIEnv *env, jobject obj)
{
	return (jint) TWAIN_CloseSource ();
}

/*
 * Class:     edu_berkeley_guir_image_eztwain_EZTwainWrapper
 * Method:    closeSourceManager
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_edu_berkeley_guir_image_eztwain_EZTwainWrapper_closeSourceManager
  (JNIEnv *env, jobject obj, jint hwnd)
{
	return (jint) TWAIN_CloseSourceManager ((HWND) hwnd);
}
