/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.util;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PStack;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class PPaintContext {
    public static final int HIGH_QUALITY_RENDERING = 0;
    public static final int LOW_QUALITY_RENDERING = 1;
    public static FontRenderContext RENDER_QUALITY_LOW_FRC = new FontRenderContext(null, false, true);
    public static FontRenderContext RENDER_QUALITY_HIGH_FRC = new FontRenderContext(null, true, true);
    public static PPaintContext CURRENT_PAINT_CONTEXT;
    private static double[] PTS;
    private Graphics2D graphics;
    protected PStack compositeStack;
    protected PStack clipStack;
    protected PStack localClipStack;
    protected PStack cameraStack;
    protected PStack transformStack;

    public PPaintContext(Graphics2D aGraphics) {
        this.graphics = aGraphics;
        this.compositeStack = new PStack();
        this.clipStack = new PStack();
        this.localClipStack = new PStack();
        this.cameraStack = new PStack();
        this.transformStack = new PStack();
        Shape clip = aGraphics.getClip();
        if (clip == null) {
            clip = new PBounds(-1.073741823E9, -1.073741823E9, 2.147483647E9, 2.147483647E9);
            aGraphics.setClip(clip);
        }
        this.localClipStack.push(clip.getBounds2D());
        CURRENT_PAINT_CONTEXT = this;
    }

    public Graphics2D getGraphics() {
        return this.graphics;
    }

    public Rectangle2D getLocalClip() {
        return (Rectangle2D)this.localClipStack.peek();
    }

    public double getScale() {
        PPaintContext.PTS[0] = 0.0;
        PPaintContext.PTS[1] = 0.0;
        PPaintContext.PTS[2] = 1.0;
        PPaintContext.PTS[3] = 0.0;
        this.graphics.getTransform().transform(PTS, 0, PTS, 0, 2);
        return Point2D.distance(PTS[0], PTS[1], PTS[2], PTS[3]);
    }

    public void pushCamera(PCamera aCamera) {
        this.cameraStack.push(aCamera);
    }

    public void popCamera(PCamera aCamera) {
        this.cameraStack.pop();
    }

    public PCamera getCamera() {
        return (PCamera)this.cameraStack.peek();
    }

    public void pushClip(Shape aClip) {
        Shape currentClip = this.graphics.getClip();
        this.clipStack.push(currentClip);
        this.graphics.clip(aClip);
        Rectangle2D newLocalClip = aClip.getBounds2D();
        Rectangle2D.intersect(this.getLocalClip(), newLocalClip, newLocalClip);
        this.localClipStack.push(newLocalClip);
    }

    public void popClip(Shape aClip) {
        Shape newClip = (Shape)this.clipStack.pop();
        this.graphics.setClip(newClip);
        this.localClipStack.pop();
    }

    public void pushTransparency(float transparency) {
        if (transparency == 1.0f) {
            return;
        }
        Composite current = this.graphics.getComposite();
        float currentAlaph = 1.0f;
        this.compositeStack.push(current);
        if (current instanceof AlphaComposite) {
            currentAlaph = ((AlphaComposite)current).getAlpha();
        }
        AlphaComposite newComposite = AlphaComposite.getInstance(3, currentAlaph * transparency);
        this.graphics.setComposite(newComposite);
    }

    public void popTransparency(float transparency) {
        if (transparency == 1.0f) {
            return;
        }
        Composite c = (Composite)this.compositeStack.pop();
        this.graphics.setComposite(c);
    }

    public void pushTransform(PAffineTransform aTransform) {
        if (aTransform == null) {
            return;
        }
        Rectangle2D newLocalClip = (Rectangle2D)this.getLocalClip().clone();
        aTransform.inverseTransform(newLocalClip, newLocalClip);
        this.transformStack.push(this.graphics.getTransform());
        this.localClipStack.push(newLocalClip);
        this.graphics.transform(aTransform);
    }

    public void popTransform(PAffineTransform aTransform) {
        if (aTransform == null) {
            return;
        }
        this.graphics.setTransform((AffineTransform)this.transformStack.pop());
        this.localClipStack.pop();
    }

    public void setRenderQuality(int requestedQuality) {
        switch (requestedQuality) {
            case 0: {
                this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                this.graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                this.graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                this.graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                break;
            }
            case 1: {
                this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                this.graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                this.graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
                this.graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            }
        }
    }

    static {
        PTS = new double[4];
    }
}

