/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.nodes;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Iterator;

public class PText
extends PNode {
    public static final String PROPERTY_TEXT = "text";
    public static final String PROPERTY_FONT = "font";
    public static Font DEFAULT_FONT = new Font("Helvetica", 0, 12);
    private String text;
    private Font font;
    private boolean constrainHeightToTextHeight = true;
    private boolean constrainWidthToTextWidth = true;
    private transient TextLayout[] lines;

    public PText() {
        this.setPaint(Color.black);
    }

    public PText(String aText) {
        this();
        this.setText(aText);
    }

    public void setConstrainWidthToTextWidth(boolean constrainWidthToTextWidth) {
        this.constrainWidthToTextWidth = constrainWidthToTextWidth;
        this.recomputeLayout();
    }

    public void setConstrainHeightToTextHeight(boolean constrainHeightToTextHeight) {
        this.constrainHeightToTextHeight = constrainHeightToTextHeight;
        this.recomputeLayout();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String aText) {
        String old = this.text;
        this.text = aText;
        this.lines = null;
        this.recomputeLayout();
        this.invalidatePaint();
        this.firePropertyChange(PROPERTY_TEXT, old, this.text);
    }

    public Font getFont() {
        if (this.font == null) {
            this.font = DEFAULT_FONT;
        }
        return this.font;
    }

    public void setFont(Font aFont) {
        Font old = this.font;
        this.font = aFont;
        this.lines = null;
        this.recomputeLayout();
        this.invalidatePaint();
        this.firePropertyChange(PROPERTY_FONT, old, this.font);
    }

    public void recomputeLayout() {
        ArrayList<TextLayout> linesList = new ArrayList<TextLayout>();
        double textWidth = this.getWidth();
        double textHeight = this.getHeight();
        if (this.constrainWidthToTextWidth) {
            textWidth = 0.0;
        }
        if (this.constrainHeightToTextHeight) {
            textHeight = 0.0;
        }
        if (this.text != null && this.text.length() > 0) {
            AttributedString atString = new AttributedString(this.text);
            atString.addAttribute(TextAttribute.FONT, this.getFont());
            AttributedCharacterIterator itr = atString.getIterator();
            LineBreakMeasurer measurer = new LineBreakMeasurer(itr, PPaintContext.RENDER_QUALITY_HIGH_FRC);
            textWidth = 0.0;
            textHeight = 0.0;
            while (measurer.getPosition() < itr.getEndIndex()) {
                TextLayout aTextLayout = null;
                aTextLayout = this.constrainWidthToTextWidth ? measurer.nextLayout(Float.MAX_VALUE) : measurer.nextLayout((float)this.getWidth());
                linesList.add(aTextLayout);
                textHeight += (double)aTextLayout.getAscent();
                textHeight += (double)(aTextLayout.getDescent() + aTextLayout.getLeading());
                textWidth = Math.max(textWidth, (double)aTextLayout.getAdvance());
            }
        }
        this.lines = new TextLayout[linesList.size()];
        int count = 0;
        Iterator i = linesList.iterator();
        while (i.hasNext()) {
            this.lines[count] = (TextLayout)i.next();
            ++count;
        }
        if (this.constrainWidthToTextWidth || this.constrainHeightToTextHeight) {
            double newWidth = this.getWidth();
            double newHeight = this.getHeight();
            if (this.constrainWidthToTextWidth) {
                newWidth = textWidth;
            }
            if (this.constrainHeightToTextHeight) {
                newHeight = textHeight;
            }
            super.setBounds(this.getX(), this.getY(), newWidth, newHeight);
        }
    }

    protected void paint(PPaintContext paintContext) {
        float x = (float)this.getX();
        float y = (float)this.getY();
        float bottomY = (float)this.getHeight() + y;
        Graphics2D g2 = paintContext.getGraphics();
        if (this.lines == null) {
            this.recomputeLayout();
            this.repaint();
            return;
        }
        g2.setPaint(this.getPaint());
        for (int i = 0; i < this.lines.length; ++i) {
            if (bottomY < (y += this.lines[i].getAscent())) {
                return;
            }
            this.lines[i].draw(g2, x, y);
            y += this.lines[i].getDescent() + this.lines[i].getLeading();
        }
    }

    public boolean setBounds(double x, double y, double width, double height) {
        if (super.setBounds(x, y, width, height)) {
            this.recomputeLayout();
            return true;
        }
        return false;
    }

    protected String paramString() {
        StringBuffer result = new StringBuffer();
        result.append("text=" + (this.text == null ? "null" : this.text));
        result.append(",font=" + (this.font == null ? "null" : this.font.toString()));
        result.append(',');
        result.append(super.paramString());
        return result.toString();
    }
}

