/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.event;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.event.PDragSequenceEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventFilter;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.geom.Point2D;

public class PPanEventHandler
extends PDragSequenceEventHandler {
    private boolean autopan;
    private double minAutopanSpeed = 5.0;
    private double maxAutopanSpeed = 15.0;

    public PPanEventHandler() {
        this.setEventFilter(new PInputEventFilter(16));
        this.setAutopan(true);
    }

    protected void drag(PInputEvent e) {
        super.drag(e);
        this.pan(e);
    }

    protected void pan(PInputEvent e) {
        PCamera c = e.getCamera();
        Point2D l = e.getPosition();
        if (c.getViewBounds().contains(l)) {
            PDimension d = e.getDelta();
            c.translateView(d.getWidth(), d.getHeight());
        }
    }

    public void setAutopan(boolean autopan) {
        this.autopan = autopan;
    }

    public boolean getAutopan() {
        return this.autopan;
    }

    public void setMinAutopanSpeed(double minAutopanSpeed) {
        this.minAutopanSpeed = minAutopanSpeed;
    }

    public void setMaxAutopanSpeed(double maxAutopanSpeed) {
        this.maxAutopanSpeed = maxAutopanSpeed;
    }

    protected void dragActivityStep(PInputEvent aEvent) {
        if (!this.autopan) {
            return;
        }
        PCamera c = aEvent.getCamera();
        PBounds b = c.getBoundsReference();
        Point2D l = aEvent.getPositionRelativeTo(c);
        int outcode = b.outcode(l);
        PDimension delta = new PDimension();
        if ((outcode & 2) != 0) {
            delta.height = this.validatePanningSpeed(-1.0 - 0.5 * Math.abs(l.getY() - b.getY()));
        } else if ((outcode & 8) != 0) {
            delta.height = this.validatePanningSpeed(1.0 + 0.5 * Math.abs(l.getY() - (b.getY() + b.getHeight())));
        }
        if ((outcode & 4) != 0) {
            delta.width = this.validatePanningSpeed(1.0 + 0.5 * Math.abs(l.getX() - (b.getX() + b.getWidth())));
        } else if ((outcode & 1) != 0) {
            delta.width = this.validatePanningSpeed(-1.0 - 0.5 * Math.abs(l.getX() - b.getX()));
        }
        c.localToView(delta);
        if (delta.width != 0.0 || delta.height != 0.0) {
            c.translateView(delta.width, delta.height);
        }
    }

    protected double validatePanningSpeed(double speed) {
        boolean speedNegative = speed < 0.0;
        if ((speed = Math.abs(speed)) < this.minAutopanSpeed) {
            speed = this.minAutopanSpeed;
        }
        if (speed > this.maxAutopanSpeed) {
            speed = this.maxAutopanSpeed;
        }
        if (speedNegative) {
            speed = -speed;
        }
        return speed;
    }

    protected String paramString() {
        StringBuffer result = new StringBuffer();
        result.append("minAutopanSpeed=" + this.minAutopanSpeed);
        result.append(",maxAutopanSpeed=" + this.maxAutopanSpeed);
        if (this.autopan) {
            result.append(",autopan");
        }
        result.append(',');
        result.append(super.paramString());
        return result.toString();
    }
}

