/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.event;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PComponent;
import edu.umd.cs.piccolo.PInputManager;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolo.util.PPickPath;
import java.awt.Cursor;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;

public class PInputEvent {
    private InputEvent inputEvent;
    private PPickPath pickPath;
    private PInputManager inputManager;
    private boolean handled;

    public PInputEvent(PInputManager inputManager, InputEvent event) {
        this.inputEvent = event;
        this.inputManager = inputManager;
    }

    public void pushCursor(Cursor cursor) {
        PComponent component = this.getTopCamera().getComponent();
        component.pushCursor(cursor);
    }

    public void popCursor() {
        PComponent component = this.getTopCamera().getComponent();
        component.popCursor();
    }

    public PCamera getCamera() {
        return this.getPath().getBottomCamera();
    }

    public PCamera getTopCamera() {
        return this.getPath().getTopCamera();
    }

    public PComponent getComponent() {
        return this.getTopCamera().getComponent();
    }

    public PInputManager getInputManager() {
        return this.inputManager;
    }

    public PPickPath getPath() {
        if (this.pickPath == null) {
            this.pickPath = this.inputManager.getMouseOver();
        }
        return this.pickPath;
    }

    public void setPath(PPickPath path) {
        this.pickPath = path;
    }

    public PNode getPickedNode() {
        return this.pickPath.getPickedNode();
    }

    public int getKeyCode() {
        if (this.isKeyEvent()) {
            KeyEvent e = (KeyEvent)this.inputEvent;
            return e.getKeyCode();
        }
        throw new IllegalStateException("Can't get keycode from mouse event");
    }

    public int getModifiers() {
        return this.inputEvent.getModifiers();
    }

    public int getClickCount() {
        if (this.isMouseEvent()) {
            return ((MouseEvent)this.inputEvent).getClickCount();
        }
        throw new IllegalStateException("Can't get clickcount from key event");
    }

    public long getWhen() {
        return this.inputEvent.getWhen();
    }

    public boolean isAltDown() {
        return this.inputEvent.isAltDown();
    }

    public boolean isControlDown() {
        return this.inputEvent.isControlDown();
    }

    public boolean isShiftDown() {
        return this.inputEvent.isShiftDown();
    }

    public boolean isHandled() {
        return this.handled;
    }

    public void setHandled(boolean handled) {
        this.handled = handled;
    }

    public int getButton() {
        if (this.isMouseEvent()) {
            return ((MouseEvent)this.inputEvent).getButton();
        }
        throw new IllegalStateException("Can't get button from key event");
    }

    public int getWheelRotation() {
        if (this.isMouseWheelEvent()) {
            return ((MouseWheelEvent)this.inputEvent).getWheelRotation();
        }
        throw new IllegalStateException("Can't get wheel rotation from non-wheel event");
    }

    private InputEvent getSourceSwingEvent() {
        return this.inputEvent;
    }

    public boolean isKeyEvent() {
        return this.inputEvent instanceof KeyEvent;
    }

    public boolean isMouseEvent() {
        return this.inputEvent instanceof MouseEvent;
    }

    public boolean isMouseWheelEvent() {
        return this.inputEvent instanceof MouseWheelEvent;
    }

    public boolean isPopupTrigger() {
        if (this.isMouseEvent()) {
            return ((MouseEvent)this.inputEvent).isPopupTrigger();
        }
        throw new IllegalStateException("Can't get clickcount from key event");
    }

    public Point2D getCanvasPosition() {
        return (Point2D)this.inputManager.getCurrentCanvasPosition().clone();
    }

    public PDimension getCanvasDelta() {
        Point2D last = this.inputManager.getLastCanvasPosition();
        Point2D current = this.inputManager.getCurrentCanvasPosition();
        return new PDimension(current.getX() - last.getX(), current.getY() - last.getY());
    }

    public Point2D getPositionRelativeTo(PNode nodeOnPath) {
        Point2D r = this.getCanvasPosition();
        return this.pickPath.canvasToLocal(r, nodeOnPath);
    }

    public PDimension getDeltaRelativeTo(PNode nodeOnPath) {
        PDimension r = this.getCanvasDelta();
        return (PDimension)this.pickPath.canvasToLocal(r, nodeOnPath);
    }

    public Point2D getPosition() {
        Point2D r = this.getCanvasPosition();
        this.pickPath.canvasToLocal(r, (PNode)this.getCamera());
        return this.getCamera().localToView(r);
    }

    public PDimension getDelta() {
        PDimension r = this.getCanvasDelta();
        this.pickPath.canvasToLocal(r, (PNode)this.getCamera());
        return (PDimension)this.getCamera().localToView(r);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(super.toString().replaceAll(".*\\.", ""));
        result.append('[');
        if (this.handled) {
            result.append("handled");
        }
        result.append(']');
        return result.toString();
    }
}

