/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo;

import edu.umd.cs.piccolo.PRoot;
import edu.umd.cs.piccolo.activities.PActivity;
import edu.umd.cs.piccolo.activities.PInterpolatingActivity;
import edu.umd.cs.piccolo.activities.PTransformActivity;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PNodeFilter;
import edu.umd.cs.piccolo.util.PObjectOutputStream;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolo.util.PPickPath;
import edu.umd.cs.piccolo.util.PUtil;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.EventListenerList;
import javax.swing.event.SwingPropertyChangeSupport;

public class PNode
implements Cloneable,
Serializable,
Printable {
    public static final String PROPERTY_CLIENT_PROPERTIES = "clientProperties";
    public static final String PROPERTY_BOUNDS = "bounds";
    public static final String PROPERTY_FULL_BOUNDS = "fullBounds";
    public static final String PROPERTY_TRANSFORM = "transform";
    public static final String PROPERTY_VISIBLE = "visible";
    public static final String PROPERTY_PAINT = "paint";
    public static final String PROPERTY_TRANSPARENCY = "transparency";
    public static final String PROPERTY_PICKABLE = "pickable";
    public static final String PROPERTY_CHILDREN_PICKABLE = "childrenPickable";
    public static final String PROPERTY_CHILDREN = "children";
    public static final String PROPERTY_PARENT = "parent";
    private static final PBounds TEMP_REPAINT_BOUNDS = new PBounds();
    private transient PNode parent;
    private List children;
    private PBounds bounds = new PBounds();
    private PAffineTransform transform;
    private Paint paint;
    private float transparency = 1.0f;
    private HashMap clientProperties;
    private PBounds fullBoundsCache = new PBounds();
    private transient SwingPropertyChangeSupport changeSupport;
    private transient EventListenerList listenerList;
    private boolean pickable = true;
    private boolean childrenPickable = true;
    private boolean visible = true;
    private boolean childBoundsVolatile;
    private boolean paintInvalid;
    private boolean childPaintInvalid;
    private boolean boundsChanged;
    private boolean fullBoundsInvalid;
    private boolean childBoundsInvalid;
    static /* synthetic */ Class class$edu$umd$cs$piccolo$event$PInputEventListener;

    public PInterpolatingActivity animateToBounds(double x, double y, double width, double height, long duration) {
        final PBounds dst = new PBounds(x, y, width, height);
        PInterpolatingActivity ta = new PInterpolatingActivity(duration, PUtil.DEFAULT_ACTIVITY_STEP_RATE){
            private PBounds src;

            protected void activityStarted() {
                this.src = PNode.this.getBounds();
                super.activityStarted();
            }

            public void setRelativeTargetValue(float zeroToOne) {
                PNode.this.setBounds(this.src.x + (double)zeroToOne * (dst.x - this.src.x), this.src.y + (double)zeroToOne * (dst.y - this.src.y), this.src.width + (double)zeroToOne * (dst.width - this.src.width), this.src.height + (double)zeroToOne * (dst.height - this.src.height));
            }
        };
        this.addActivity(ta);
        return ta;
    }

    public PTransformActivity animateToPositionScaleRotation(double x, double y, double scale, double theta, long duration) {
        PAffineTransform t = this.getTransform();
        t.setOffset(x, y);
        t.setScale(scale);
        t.setRotation(theta);
        return this.animateToTransform(t, duration);
    }

    public PTransformActivity animateToTransform(AffineTransform destTransform, long duration) {
        PTransformActivity.Target t = new PTransformActivity.Target(){

            public void setTransform(AffineTransform aTransform) {
                PNode.this.setTransform(aTransform);
            }

            public void getSourceMatrix(double[] aSource) {
                PNode.this.getTransformReference(true).getMatrix(aSource);
            }
        };
        PTransformActivity ta = new PTransformActivity(duration, PUtil.DEFAULT_ACTIVITY_STEP_RATE, t, destTransform);
        this.addActivity(ta);
        return ta;
    }

    public PInterpolatingActivity animateToTransparency(float zeroToOne, long duration) {
        final float dest = zeroToOne;
        PInterpolatingActivity ta = new PInterpolatingActivity(duration, PUtil.DEFAULT_ACTIVITY_STEP_RATE){
            private float source;

            protected void activityStarted() {
                this.source = PNode.this.getTransparency();
                super.activityStarted();
            }

            public void setRelativeTargetValue(float zeroToOne) {
                PNode.this.setTransparency(this.source + zeroToOne * (dest - this.source));
            }
        };
        this.addActivity(ta);
        return ta;
    }

    public boolean addActivity(PActivity activity) {
        PRoot r = this.getRoot();
        if (r != null) {
            return r.addActivity(activity);
        }
        return false;
    }

    public Object getClientProperty(Object key) {
        if (this.clientProperties == null || key == null) {
            return null;
        }
        return this.clientProperties.get(key);
    }

    public void addClientProperty(Object key, Object value) {
        if (value == null && this.clientProperties == null) {
            return;
        }
        if (this.clientProperties == null) {
            this.clientProperties = new HashMap();
        }
        if (value == null) {
            this.clientProperties.remove(key);
        } else {
            this.clientProperties.put(key, value);
        }
        if (this.clientProperties.size() == 0) {
            this.clientProperties = null;
        }
        this.firePropertyChange(PROPERTY_CLIENT_PROPERTIES, null, this.clientProperties);
    }

    public Iterator getClientPropertyKeysIterator() {
        if (this.clientProperties == null) {
            return PUtil.NULL_ITERATOR;
        }
        return this.clientProperties.keySet().iterator();
    }

    public Object clone() {
        try {
            byte[] ser = PObjectOutputStream.toByteArray(this);
            return (PNode)new ObjectInputStream(new ByteArrayInputStream(ser)).readObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Point2D localToParent(Point2D localPoint) {
        if (this.transform == null) {
            return localPoint;
        }
        return this.transform.transform(localPoint, localPoint);
    }

    public Dimension2D localToParent(Dimension2D localDimension) {
        if (this.transform == null) {
            return localDimension;
        }
        return this.transform.transform(localDimension, localDimension);
    }

    public Rectangle2D localToParent(Rectangle2D localRectangle) {
        if (this.transform == null) {
            return localRectangle;
        }
        return this.transform.transform(localRectangle, localRectangle);
    }

    public Point2D parentToLocal(Point2D parentPoint) {
        if (this.transform == null) {
            return parentPoint;
        }
        try {
            return this.transform.inverseTransform(parentPoint, parentPoint);
        }
        catch (NoninvertibleTransformException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Dimension2D parentToLocal(Dimension2D parentDimension) {
        if (this.transform == null) {
            return parentDimension;
        }
        return this.transform.inverseTransform(parentDimension, parentDimension);
    }

    public Rectangle2D parentToLocal(Rectangle2D parentRectangle) {
        if (this.transform == null) {
            return parentRectangle;
        }
        return this.transform.inverseTransform(parentRectangle, parentRectangle);
    }

    public Point2D localToGlobal(Point2D localPoint) {
        PNode n = this;
        while (n != null) {
            localPoint = n.localToParent(localPoint);
            n = n.parent;
        }
        return localPoint;
    }

    public Dimension2D localToGlobal(Dimension2D localDimension) {
        PNode n = this;
        while (n != null) {
            localDimension = n.localToParent(localDimension);
            n = n.parent;
        }
        return localDimension;
    }

    public Rectangle2D localToGlobal(Rectangle2D localRectangle) {
        PNode n = this;
        while (n != null) {
            localRectangle = n.localToParent(localRectangle);
            n = n.parent;
        }
        return localRectangle;
    }

    public Point2D globalToLocal(Point2D globalPoint) {
        if (this.parent != null) {
            globalPoint = this.parent.globalToLocal(globalPoint);
        }
        return this.parentToLocal(globalPoint);
    }

    public Dimension2D globalToLocal(Dimension2D globalDimension) {
        if (this.parent != null) {
            globalDimension = this.parent.globalToLocal(globalDimension);
        }
        return this.parentToLocal(globalDimension);
    }

    public Rectangle2D globalToLocal(Rectangle2D globalRectangle) {
        if (this.parent != null) {
            globalRectangle = this.parent.globalToLocal(globalRectangle);
        }
        return this.parentToLocal(globalRectangle);
    }

    public PAffineTransform getLocalToGlobalTransform(PAffineTransform dest) {
        if (this.parent != null) {
            dest = this.parent.getLocalToGlobalTransform(dest);
            if (this.transform != null) {
                dest.concatenate(this.transform);
            }
        } else if (dest == null) {
            dest = this.getTransform();
        } else if (this.transform != null) {
            dest.setTransform(this.transform);
        } else {
            dest.setToIdentity();
        }
        return dest;
    }

    public PAffineTransform getGlobalToLocalTransform(PAffineTransform dest) {
        try {
            dest = this.getLocalToGlobalTransform(dest);
            dest.setTransform(dest.createInverse());
            return dest;
        }
        catch (NoninvertibleTransformException e) {
            e.printStackTrace();
            return null;
        }
    }

    public EventListenerList getListenerList() {
        return this.listenerList;
    }

    public void addInputEventListener(PInputEventListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.getListenerList().add(class$edu$umd$cs$piccolo$event$PInputEventListener == null ? (class$edu$umd$cs$piccolo$event$PInputEventListener = PNode.class$("edu.umd.cs.piccolo.event.PInputEventListener")) : class$edu$umd$cs$piccolo$event$PInputEventListener, listener);
    }

    public void removeInputEventListener(PInputEventListener listener) {
        if (this.listenerList == null) {
            return;
        }
        this.getListenerList().remove(class$edu$umd$cs$piccolo$event$PInputEventListener == null ? (class$edu$umd$cs$piccolo$event$PInputEventListener = PNode.class$("edu.umd.cs.piccolo.event.PInputEventListener")) : class$edu$umd$cs$piccolo$event$PInputEventListener, listener);
        if (this.listenerList.getListenerCount() == 0) {
            this.listenerList = null;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(listener);
        }
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public PBounds getBounds() {
        return (PBounds)this.getBoundsReference().clone();
    }

    public PBounds getBoundsReference() {
        return this.bounds;
    }

    public void startResizeBounds() {
    }

    public void endResizeBounds() {
    }

    public boolean setBounds(Rectangle2D newBounds) {
        return this.setBounds(newBounds.getX(), newBounds.getY(), newBounds.getWidth(), newBounds.getHeight());
    }

    public boolean setBounds(double x, double y, double width, double height) {
        if (this.bounds.x != x || this.bounds.y != y || this.bounds.width != width || this.bounds.height != height) {
            this.bounds.setRect(x, y, width, height);
            if (width <= 0.0 || height <= 0.0) {
                this.bounds.reset();
            }
            this.invalidatePaint();
            this.signalBoundsChanged();
            return true;
        }
        return false;
    }

    public void resetBounds() {
        this.setBounds(0.0, 0.0, 0.0, 0.0);
    }

    public double getX() {
        return this.getBoundsReference().getX();
    }

    public double getY() {
        return this.getBoundsReference().getY();
    }

    public double getWidth() {
        return this.getBoundsReference().getWidth();
    }

    public double getHeight() {
        return this.getBoundsReference().getHeight();
    }

    public boolean centerBoundsOnPoint(double localX, double localY) {
        double dx = localX - this.bounds.getCenterX();
        double dy = localY - this.bounds.getCenterY();
        return this.setBounds(this.bounds.x + dx, this.bounds.y + dy, this.bounds.width, this.bounds.height);
    }

    public boolean intersects(Rectangle2D localBounds) {
        if (localBounds == null) {
            return true;
        }
        return this.getBoundsReference().intersects(localBounds);
    }

    public PBounds getFullBounds() {
        return (PBounds)this.getFullBoundsReference().clone();
    }

    public PBounds getFullBoundsReference() {
        this.validateFullBounds();
        return this.fullBoundsCache;
    }

    public PBounds computeFullBounds(PBounds dstBounds) {
        PBounds result = this.getUnionOfChildrenBounds(dstBounds);
        result.add(this.getBoundsReference());
        this.localToParent(result);
        return result;
    }

    public PBounds getUnionOfChildrenBounds(PBounds dstBounds) {
        if (dstBounds == null) {
            dstBounds = new PBounds();
        } else {
            dstBounds.resetToZero();
        }
        int count = this.getChildrenCount();
        for (int i = 0; i < count; ++i) {
            PNode each = (PNode)this.children.get(i);
            dstBounds.add(each.getFullBoundsReference());
        }
        return dstBounds;
    }

    public PBounds getGlobalFullBounds() {
        PBounds b = this.getFullBounds();
        if (this.parent != null) {
            this.parent.localToGlobal(b);
        }
        return b;
    }

    public boolean fullIntersects(Rectangle2D parentBounds) {
        if (parentBounds == null) {
            return true;
        }
        return this.getFullBoundsReference().intersects(parentBounds);
    }

    protected boolean getBoundsVolatile() {
        return false;
    }

    protected boolean getChildBoundsVolatile() {
        return this.childBoundsVolatile;
    }

    protected void setChildBoundsVolatile(boolean childBoundsVolatile) {
        this.childBoundsVolatile = childBoundsVolatile;
    }

    protected boolean getBoundsChanged() {
        return this.boundsChanged;
    }

    protected void setBoundsChanged(boolean boundsChanged) {
        this.boundsChanged = boundsChanged;
    }

    protected boolean getFullBoundsInvalid() {
        return this.fullBoundsInvalid;
    }

    protected void setFullBoundsInvalid(boolean fullBoundsInvalid) {
        this.fullBoundsInvalid = fullBoundsInvalid;
    }

    protected boolean getChildBoundsInvalid() {
        return this.childBoundsInvalid;
    }

    protected void setChildBoundsInvalid(boolean childBoundsInvalid) {
        this.childBoundsInvalid = childBoundsInvalid;
    }

    public void signalBoundsChanged() {
        this.invalidateFullBounds();
        this.setBoundsChanged(true);
        this.firePropertyChange(PROPERTY_BOUNDS, null, this.bounds);
        int count = this.getChildrenCount();
        for (int i = 0; i < count; ++i) {
            PNode each = (PNode)this.children.get(i);
            each.parentBoundsChanged();
        }
    }

    public void invalidateLayout() {
        this.invalidateFullBounds();
    }

    protected void parentBoundsChanged() {
    }

    public void invalidateFullBounds() {
        this.setFullBoundsInvalid(true);
        PNode n = this.parent;
        while (n != null && !n.getChildBoundsInvalid()) {
            n.setChildBoundsInvalid(true);
            n = n.parent;
        }
    }

    protected boolean validateFullBounds() {
        boolean boundsVolatile = this.getBoundsVolatile();
        if (this.fullBoundsInvalid || this.childBoundsInvalid || boundsVolatile || this.childBoundsVolatile) {
            if (boundsVolatile && !this.boundsChanged) {
                this.signalBoundsChanged();
            }
            if (this.childBoundsInvalid || this.childBoundsVolatile) {
                this.childBoundsVolatile = false;
                int count = this.getChildrenCount();
                for (int i = 0; i < count; ++i) {
                    PNode each = (PNode)this.children.get(i);
                    this.childBoundsVolatile |= each.validateFullBounds();
                }
            }
            this.layoutChildren();
            if (this.fullBoundsInvalid) {
                boolean fullBoundsChanged;
                double oldX = this.fullBoundsCache.x;
                double oldY = this.fullBoundsCache.y;
                double oldWidth = this.fullBoundsCache.width;
                double oldHeight = this.fullBoundsCache.height;
                boolean oldEmpty = this.fullBoundsCache.isEmpty();
                this.fullBoundsCache = this.computeFullBounds(this.fullBoundsCache);
                boolean bl = fullBoundsChanged = this.fullBoundsCache.x != oldX || this.fullBoundsCache.y != oldY || this.fullBoundsCache.width != oldWidth || this.fullBoundsCache.height != oldHeight || this.fullBoundsCache.isEmpty() != oldEmpty;
                if (fullBoundsChanged) {
                    if (this.parent != null) {
                        this.parent.invalidateFullBounds();
                    }
                    this.firePropertyChange(PROPERTY_FULL_BOUNDS, null, this.fullBoundsCache);
                    if (this.paintInvalid && !oldEmpty) {
                        TEMP_REPAINT_BOUNDS.setRect(oldX, oldY, oldWidth, oldHeight);
                        this.repaintFrom(TEMP_REPAINT_BOUNDS, this);
                    }
                }
            }
            this.boundsChanged = false;
            this.fullBoundsInvalid = false;
            this.childBoundsInvalid = false;
        }
        return boundsVolatile || this.childBoundsVolatile;
    }

    protected void layoutChildren() {
    }

    public double getRotation() {
        if (this.transform == null) {
            return 0.0;
        }
        return this.transform.getRotation();
    }

    public void setRotation(double theta) {
        this.rotate(theta - this.getRotation());
    }

    public void rotate(double theta) {
        this.rotateAboutPoint(theta, 0.0, 0.0);
    }

    public void rotateInPlace(double theta) {
        PBounds b = this.getFullBoundsReference();
        double px = b.x;
        double py = b.y;
        this.rotateAboutPoint(theta, 0.0, 0.0);
        b = this.getFullBoundsReference();
        this.offset(px - b.x, py - b.y);
    }

    public void rotateAboutPoint(double theta, Point2D point) {
        this.rotateAboutPoint(theta, point.getX(), point.getY());
    }

    public void rotateAboutPoint(double theta, double x, double y) {
        this.getTransformReference(true).rotate(theta, x, y);
        this.invalidatePaint();
        this.invalidateFullBounds();
        this.firePropertyChange(PROPERTY_TRANSFORM, null, this.transform);
    }

    public double getGlobalRotation() {
        return this.getLocalToGlobalTransform(null).getRotation();
    }

    public void setGlobalRotation(double theta) {
        if (this.parent != null) {
            this.setRotation(theta - this.parent.getGlobalRotation());
        } else {
            this.setRotation(theta);
        }
    }

    public double getScale() {
        if (this.transform == null) {
            return 1.0;
        }
        return this.transform.getScale();
    }

    public void setScale(double scale) {
        this.scale(scale / this.getScale());
    }

    public void scale(double scale) {
        this.scaleAboutPoint(scale, 0.0, 0.0);
    }

    public void scaleAboutPoint(double scale, Point2D point) {
        this.scaleAboutPoint(scale, point.getX(), point.getY());
    }

    public void scaleAboutPoint(double scale, double x, double y) {
        this.getTransformReference(true).scaleAboutPoint(scale, x, y);
        this.invalidatePaint();
        this.invalidateFullBounds();
        this.firePropertyChange(PROPERTY_TRANSFORM, null, this.transform);
    }

    public double getGlobalScale() {
        return this.getLocalToGlobalTransform(null).getScale();
    }

    public void setGlobalScale(double scale) {
        if (this.parent != null) {
            this.setScale(scale / this.parent.getGlobalScale());
        } else {
            this.setScale(scale);
        }
    }

    public Point2D getOffset() {
        if (this.transform == null) {
            return new Point2D.Double();
        }
        return new Point2D.Double(this.transform.getTranslateX(), this.transform.getTranslateY());
    }

    public void setOffset(Point2D point) {
        this.setOffset(point.getX(), point.getY());
    }

    public void setOffset(double x, double y) {
        this.getTransformReference(true).setOffset(x, y);
        this.invalidatePaint();
        this.invalidateFullBounds();
        this.firePropertyChange(PROPERTY_TRANSFORM, null, this.transform);
    }

    public void offset(double dx, double dy) {
        this.getTransformReference(true);
        this.setOffset(this.transform.getTranslateX() + dx, this.transform.getTranslateY() + dy);
    }

    public void translate(double dx, double dy) {
        this.getTransformReference(true).translate(dx, dy);
        this.invalidatePaint();
        this.invalidateFullBounds();
        this.firePropertyChange(PROPERTY_TRANSFORM, null, this.transform);
    }

    public Point2D getGlobalTranslation() {
        Point2D p = this.getOffset();
        if (this.parent != null) {
            this.parent.localToGlobal(p);
        }
        return p;
    }

    public void setGlobalTranslation(Point2D globalPoint) {
        if (this.parent != null) {
            this.parent.getGlobalToLocalTransform(null).transform(globalPoint, globalPoint);
        }
        this.setOffset(globalPoint);
    }

    public void transformBy(AffineTransform aTransform) {
        this.getTransformReference(true).concatenate(aTransform);
        this.invalidatePaint();
        this.invalidateFullBounds();
        this.firePropertyChange(PROPERTY_TRANSFORM, null, this.transform);
    }

    public static double lerp(double t, double a, double b) {
        return a + t * (b - a);
    }

    public void position(Point2D srcPt, Point2D destPt, Rectangle2D destBounds, int millis) {
        if (this.parent != null) {
            PBounds srcBounds = this.getGlobalFullBounds();
            double srcx = PNode.lerp(srcPt.getX(), ((RectangularShape)srcBounds).getX(), ((RectangularShape)srcBounds).getX() + ((RectangularShape)srcBounds).getWidth());
            double srcy = PNode.lerp(srcPt.getY(), ((RectangularShape)srcBounds).getY(), ((RectangularShape)srcBounds).getY() + ((RectangularShape)srcBounds).getHeight());
            double destx = PNode.lerp(destPt.getX(), destBounds.getX(), destBounds.getX() + destBounds.getWidth());
            double desty = PNode.lerp(destPt.getY(), destBounds.getY(), destBounds.getY() + destBounds.getHeight());
            Point2D.Double pt1 = new Point2D.Double(srcx, srcy);
            this.globalToLocal(pt1);
            Point2D.Double pt2 = new Point2D.Double(destx, desty);
            this.globalToLocal(pt2);
            double dx = ((Point2D)pt2).getX() - ((Point2D)pt1).getX();
            double dy = ((Point2D)pt2).getY() - ((Point2D)pt1).getY();
            PAffineTransform at = new PAffineTransform(this.transform);
            at.translate(dx, dy);
            this.animateToTransform(at, millis);
        }
    }

    public PAffineTransform getTransform() {
        if (this.transform == null) {
            return new PAffineTransform();
        }
        return (PAffineTransform)this.transform.clone();
    }

    public PAffineTransform getTransformReference(boolean createNewTransformIfNull) {
        if (this.transform == null && createNewTransformIfNull) {
            this.transform = new PAffineTransform();
        }
        return this.transform;
    }

    public PAffineTransform getInverseTransform() {
        if (this.transform == null) {
            return new PAffineTransform();
        }
        try {
            return new PAffineTransform(this.transform.createInverse());
        }
        catch (NoninvertibleTransformException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setTransform(AffineTransform newTransform) {
        this.getTransformReference(true).setTransform(newTransform);
        this.invalidatePaint();
        this.invalidateFullBounds();
        this.firePropertyChange(PROPERTY_TRANSFORM, null, this.transform);
    }

    public boolean getPaintInvalid() {
        return this.paintInvalid;
    }

    public void setPaintInvalid(boolean paintInvalid) {
        this.paintInvalid = paintInvalid;
    }

    public boolean getChildPaintInvalid() {
        return this.childPaintInvalid;
    }

    public void setChildPaintInvalid(boolean childPaintInvalid) {
        this.childPaintInvalid = childPaintInvalid;
    }

    public void invalidatePaint() {
        this.setPaintInvalid(true);
        PNode n = this.parent;
        while (n != null && !n.getChildPaintInvalid()) {
            n.setChildPaintInvalid(true);
            n = n.parent;
        }
    }

    public void validateFullPaint() {
        if (this.getPaintInvalid()) {
            this.repaint();
            this.setPaintInvalid(false);
        }
        if (this.getChildPaintInvalid()) {
            int count = this.getChildrenCount();
            for (int i = 0; i < count; ++i) {
                PNode each = (PNode)this.children.get(i);
                each.validateFullPaint();
            }
            this.setChildPaintInvalid(false);
        }
    }

    public void repaint() {
        TEMP_REPAINT_BOUNDS.setRect(this.getFullBoundsReference());
        this.repaintFrom(TEMP_REPAINT_BOUNDS, this);
    }

    public void repaintFrom(PBounds localBounds, PNode childOrThis) {
        if (this.parent != null) {
            if (childOrThis != this) {
                this.localToParent(localBounds);
            }
            this.parent.repaintFrom(localBounds, this);
        }
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setVisible(boolean isVisible) {
        if (this.getVisible() != isVisible) {
            this.visible = isVisible;
            this.firePropertyChange(PROPERTY_VISIBLE, null, null);
            this.invalidatePaint();
        }
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint newPaint) {
        if (this.paint == newPaint) {
            return;
        }
        Paint old = this.paint;
        this.paint = newPaint;
        this.invalidatePaint();
        this.firePropertyChange(PROPERTY_PAINT, old, this.paint);
    }

    public float getTransparency() {
        return this.transparency;
    }

    public void setTransparency(float zeroToOne) {
        if (this.transparency == zeroToOne) {
            return;
        }
        this.transparency = zeroToOne;
        this.invalidatePaint();
        this.firePropertyChange(PROPERTY_TRANSPARENCY, null, null);
    }

    protected void paint(PPaintContext paintContext) {
        if (this.paint != null) {
            Graphics2D g2 = paintContext.getGraphics();
            g2.setPaint(this.paint);
            g2.fill(this.getBoundsReference());
        }
    }

    public void fullPaint(PPaintContext paintContext) {
        if (this.getVisible() && this.fullIntersects(paintContext.getLocalClip())) {
            paintContext.pushTransform(this.transform);
            paintContext.pushTransparency(this.transparency);
            this.paint(paintContext);
            int count = this.getChildrenCount();
            for (int i = 0; i < count; ++i) {
                PNode each = (PNode)this.children.get(i);
                each.fullPaint(paintContext);
            }
            this.paintAfterChildren(paintContext);
            paintContext.popTransparency(this.transparency);
            paintContext.popTransform(this.transform);
        }
    }

    protected void paintAfterChildren(PPaintContext paintContext) {
    }

    public Image toImage() {
        PBounds b = this.getFullBoundsReference();
        return this.toImage((int)Math.ceil(b.getWidth()), (int)Math.ceil(b.getHeight()), null);
    }

    public Image toImage(int width, int height, Paint backGroundPaint) {
        PBounds bnds = this.getFullBounds();
        bnds.expandNearestIntegerDimensions();
        if ((double)width / bnds.width < (double)height / bnds.height) {
            double scale = (double)width / bnds.width;
            height = (int)(bnds.height * scale);
        } else {
            double scale = (double)height / bnds.height;
            width = (int)(bnds.width * scale);
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage result = null;
        Graphics2D g2 = null;
        if (backGroundPaint == null) {
            result = graphicsConfiguration.createCompatibleImage(width, height, 3);
            g2 = result.createGraphics();
        } else {
            result = graphicsConfiguration.createCompatibleImage(width, height, 1);
            g2 = result.createGraphics();
            g2.setPaint(backGroundPaint);
            g2.fillRect(0, 0, width, height);
        }
        Paper paper = new Paper();
        paper.setSize(width, height);
        paper.setImageableArea(0.0, 0.0, width, height);
        PageFormat pageFormat = new PageFormat();
        pageFormat.setPaper(paper);
        this.print(g2, pageFormat, 0);
        return result;
    }

    public void print() {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = printJob.defaultPage();
        Book book = new Book();
        book.append(this, pageFormat);
        printJob.setPageable(book);
        if (printJob.printDialog()) {
            try {
                printJob.print();
            }
            catch (Exception e) {
                System.out.println("Error Printing");
                e.printStackTrace();
            }
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        if (pageIndex != 0) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)graphics;
        PBounds bounds = this.getFullBounds();
        bounds.expandNearestIntegerDimensions();
        g2.setClip(0, 0, (int)pageFormat.getWidth(), (int)pageFormat.getHeight());
        g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        double scale = pageFormat.getImageableWidth() / bounds.getWidth();
        if (pageFormat.getImageableHeight() / bounds.getHeight() < scale) {
            scale = pageFormat.getImageableHeight() / bounds.getHeight();
        }
        g2.scale(scale, scale);
        g2.translate(-bounds.x, -bounds.y);
        PPaintContext pc = new PPaintContext(g2);
        pc.setRenderQuality(0);
        this.fullPaint(pc);
        return 0;
    }

    public boolean getPickable() {
        return this.pickable;
    }

    public void setPickable(boolean isPickable) {
        if (this.getPickable() != isPickable) {
            this.pickable = isPickable;
            this.firePropertyChange(PROPERTY_PICKABLE, null, null);
        }
    }

    public boolean getChildrenPickable() {
        return this.childrenPickable;
    }

    public void setChildrenPickable(boolean areChildrenPickable) {
        if (this.getChildrenPickable() != areChildrenPickable) {
            this.childrenPickable = areChildrenPickable;
            this.firePropertyChange(PROPERTY_CHILDREN_PICKABLE, null, null);
        }
    }

    protected boolean pick(PPickPath pickPath) {
        return false;
    }

    public boolean fullPick(PPickPath pickPath) {
        if (this.getPickable() && this.fullIntersects(pickPath.getPickBounds())) {
            pickPath.pushNode(this);
            pickPath.pushTransform(this.transform);
            if (this.pick(pickPath)) {
                return true;
            }
            if (this.getChildrenPickable()) {
                int count = this.getChildrenCount();
                for (int i = count - 1; i >= 0; --i) {
                    PNode each = (PNode)this.children.get(i);
                    if (!each.fullPick(pickPath)) continue;
                    return true;
                }
            }
            if (this.pickAfterChildren(pickPath)) {
                return true;
            }
            pickPath.popTransform(this.transform);
            pickPath.popNode(this);
        }
        return false;
    }

    protected boolean pickAfterChildren(PPickPath pickPath) {
        return this.intersects(pickPath.getPickBounds());
    }

    public void addChild(PNode child) {
        int insertIndex = this.getChildrenCount();
        if (child.parent == this) {
            --insertIndex;
        }
        this.addChild(insertIndex, child);
    }

    public void addChild(int index, PNode child) {
        PNode oldParent = child.getParent();
        if (oldParent != null) {
            oldParent.removeChild(child);
        }
        child.setParent(this);
        this.getChildrenReference().add(index, child);
        child.invalidatePaint();
        this.invalidateFullBounds();
        this.firePropertyChange(PROPERTY_CHILDREN, null, this.children);
    }

    public void addChildren(Collection nodes) {
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            PNode each = (PNode)i.next();
            this.addChild(each);
        }
    }

    public boolean isAncestorOf(PNode node) {
        PNode p = node.parent;
        while (p != null) {
            if (p == this) {
                return true;
            }
            p = p.parent;
        }
        return false;
    }

    public boolean isDescendentOf(PNode node) {
        PNode p = this.parent;
        while (p != null) {
            if (p == node) {
                return true;
            }
            p = p.parent;
        }
        return false;
    }

    public boolean isDescendentOfRoot() {
        return this.getRoot() != null;
    }

    public void moveToBack() {
        if (this.parent != null) {
            this.parent.moveToBack(this);
        }
    }

    public void moveToBack(PNode child) {
        this.removeChild(child);
        this.addChild(0, child);
    }

    public void moveToFront() {
        if (this.parent != null) {
            this.parent.moveToFront(this);
        }
    }

    public void moveToFront(PNode child) {
        this.removeChild(child);
        this.addChild(child);
    }

    public PNode getParent() {
        return this.parent;
    }

    public void setParent(PNode newParent) {
        PNode old = this.parent;
        this.parent = newParent;
        this.firePropertyChange(PROPERTY_PARENT, old, this.parent);
    }

    public int indexOfChild(PNode child) {
        return this.children.indexOf(child);
    }

    public PNode removeChild(PNode child) {
        return this.removeChild(this.indexOfChild(child));
    }

    public PNode removeChild(int index) {
        PNode child = (PNode)this.children.remove(index);
        if (this.children.size() == 0) {
            this.children = null;
        }
        child.repaint();
        child.setParent(null);
        this.invalidateFullBounds();
        this.firePropertyChange(PROPERTY_CHILDREN, null, this.children);
        return child;
    }

    public void removeChildren(Collection childrenNodes) {
        Iterator i = childrenNodes.iterator();
        while (i.hasNext()) {
            PNode each = (PNode)i.next();
            this.removeChild(each);
        }
    }

    public void removeAllChildren() {
        if (this.children != null) {
            int count = this.children.size();
            for (int i = 0; i < count; ++i) {
                PNode each = (PNode)this.children.get(i);
                each.setParent(null);
            }
            this.children = null;
            this.invalidatePaint();
            this.invalidateFullBounds();
            this.firePropertyChange(PROPERTY_CHILDREN, null, this.children);
        }
    }

    public void removeFromParent() {
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
    }

    public void reparent(PNode newParent) {
        PAffineTransform originalTransform = this.getLocalToGlobalTransform(null);
        PAffineTransform newTransform = newParent.getGlobalToLocalTransform(null);
        newTransform.concatenate(originalTransform);
        this.removeFromParent();
        this.setTransform(newTransform);
        newParent.addChild(this);
        this.computeFullBounds(this.fullBoundsCache);
    }

    public void replaceWith(PNode replacementNode) {
        if (this.parent != null) {
            int index = this.parent.getChildrenReference().indexOf(this);
            this.parent.removeChild(this);
            this.parent.addChild(index, replacementNode);
        }
    }

    public int getChildrenCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public PNode getChild(int index) {
        return (PNode)this.children.get(index);
    }

    public List getChildrenReference() {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        return this.children;
    }

    public Iterator getChildrenIterator() {
        if (this.children == null) {
            return PUtil.NULL_ITERATOR;
        }
        return this.children.iterator();
    }

    public PRoot getRoot() {
        if (this.parent != null) {
            return this.parent.getRoot();
        }
        return null;
    }

    public Collection getAllNodes() {
        return this.getAllNodes(null, null);
    }

    public Collection getAllNodes(PNodeFilter filter, Collection results) {
        if (results == null) {
            results = new ArrayList<PNode>();
        }
        if (filter == null || filter.accept(this)) {
            results.add(this);
        }
        if (filter == null || filter.acceptChildrenOf(this)) {
            int count = this.getChildrenCount();
            for (int i = 0; i < count; ++i) {
                PNode each = (PNode)this.children.get(i);
                each.getAllNodes(filter, results);
            }
        }
        return results;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        ((PObjectOutputStream)out).writeConditionalObject(this.parent);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.parent = (PNode)in.readObject();
    }

    public String toString() {
        String result = super.toString().replaceAll(".*\\.", "");
        return result + "[" + this.paramString() + "]";
    }

    protected String paramString() {
        StringBuffer result = new StringBuffer();
        result.append("bounds=" + (this.bounds == null ? "null" : this.bounds.toString()));
        result.append(",fullBounds=" + (this.fullBoundsCache == null ? "null" : this.fullBoundsCache.toString()));
        result.append(",transform=" + (this.transform == null ? "null" : this.transform.toString()));
        result.append(",paint=" + (this.paint == null ? "null" : this.paint.toString()));
        result.append(",transparency=" + this.transparency);
        result.append(",childrenCount=" + this.getChildrenCount());
        if (this.fullBoundsInvalid) {
            result.append(",fullBoundsInvalid");
        }
        if (this.pickable) {
            result.append(",pickable");
        }
        if (this.childrenPickable) {
            result.append(",childrenPickable");
        }
        if (this.visible) {
            result.append(",visible");
        }
        return result.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

