/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xpath.internal.functions;

import com.sun.org.apache.xpath.internal.Expression;
import com.sun.org.apache.xpath.internal.ExpressionNode;
import com.sun.org.apache.xpath.internal.ExpressionOwner;
import com.sun.org.apache.xpath.internal.ExtensionsProvider;
import com.sun.org.apache.xpath.internal.XPathContext;
import com.sun.org.apache.xpath.internal.XPathVisitor;
import com.sun.org.apache.xpath.internal.functions.Function;
import com.sun.org.apache.xpath.internal.functions.WrongNumberArgsException;
import com.sun.org.apache.xpath.internal.objects.XNull;
import com.sun.org.apache.xpath.internal.objects.XObject;
import com.sun.org.apache.xpath.internal.res.XPATHMessages;
import java.util.Vector;
import javax.xml.transform.TransformerException;

public class FuncExtFunction
extends Function {
    String m_namespace;
    String m_extensionName;
    Object m_methodKey;
    Vector m_argVec = new Vector();

    public int getArgCount() {
        return this.m_argVec.size();
    }

    protected void reportWrongNumberArgs() throws WrongNumberArgsException {
        String fMsg = XPATHMessages.createXPATHMessage("ER_INCORRECT_PROGRAMMER_ASSERTION", new Object[]{"Programmer's assertion:  the method FunctionMultiArgs.reportWrongNumberArgs() should never be called."});
        throw new RuntimeException(fMsg);
    }

    public void checkNumberArgs(int argNum) throws WrongNumberArgsException {
    }

    public Expression getArg(int n) {
        if (n >= 0 && n < this.m_argVec.size()) {
            return (Expression)this.m_argVec.elementAt(n);
        }
        return null;
    }

    public void setArg(Expression arg, int argNum) throws WrongNumberArgsException {
        this.m_argVec.addElement(arg);
    }

    public void exprSetParent(ExpressionNode n) {
        super.exprSetParent(n);
        int nArgs = this.m_argVec.size();
        int i = 0;
        while (i < nArgs) {
            Expression arg = (Expression)this.m_argVec.elementAt(i);
            arg.exprSetParent(n);
            ++i;
        }
    }

    public void callArgVisitors(XPathVisitor visitor) {
        int i = 0;
        while (i < this.m_argVec.size()) {
            Expression exp = (Expression)this.m_argVec.elementAt(i);
            exp.callVisitors(new ArgExtOwner(exp), visitor);
            ++i;
        }
    }

    public Object getMethodKey() {
        return this.m_methodKey;
    }

    public String getFunctionName() {
        return this.m_extensionName;
    }

    public String getNamespace() {
        return this.m_namespace;
    }

    public void fixupVariables(Vector vars, int globalsSize) {
        if (null != this.m_argVec) {
            int nArgs = this.m_argVec.size();
            int i = 0;
            while (i < nArgs) {
                Expression arg = (Expression)this.m_argVec.elementAt(i);
                arg.fixupVariables(vars, globalsSize);
                ++i;
            }
        }
    }

    public XObject execute(XPathContext xctxt) throws TransformerException {
        Vector<XObject> argVec = new Vector<XObject>();
        int nArgs = this.m_argVec.size();
        int i = 0;
        while (i < nArgs) {
            Expression arg = (Expression)this.m_argVec.elementAt(i);
            XObject xobj = arg.execute(xctxt);
            xobj.allowDetachToRelease(false);
            argVec.addElement(xobj);
            ++i;
        }
        ExtensionsProvider extProvider = (ExtensionsProvider)xctxt.getOwnerObject();
        Object val = extProvider.extFunction(this, argVec);
        XObject result = null != val ? XObject.create(val, xctxt) : new XNull();
        return result;
    }

    public FuncExtFunction(String namespace, String extensionName, Object methodKey) {
        this.m_namespace = namespace;
        this.m_extensionName = extensionName;
        this.m_methodKey = methodKey;
    }

    class ArgExtOwner
    implements ExpressionOwner {
        Expression m_exp;

        public Expression getExpression() {
            return this.m_exp;
        }

        public void setExpression(Expression exp) {
            exp.exprSetParent(FuncExtFunction.this);
            this.m_exp = exp;
        }

        ArgExtOwner(Expression exp) {
            this.m_exp = exp;
        }
    }
}

