/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xpath.internal.axes;

import com.sun.org.apache.xml.internal.dtm.DTM;
import com.sun.org.apache.xml.internal.dtm.DTMAxisTraverser;
import com.sun.org.apache.xpath.internal.Expression;
import com.sun.org.apache.xpath.internal.ExpressionOwner;
import com.sun.org.apache.xpath.internal.XPathContext;
import com.sun.org.apache.xpath.internal.XPathVisitor;
import com.sun.org.apache.xpath.internal.axes.LocPathIterator;
import com.sun.org.apache.xpath.internal.axes.PathComponent;
import com.sun.org.apache.xpath.internal.axes.PredicatedNodeTest;
import com.sun.org.apache.xpath.internal.axes.WalkerFactory;
import com.sun.org.apache.xpath.internal.axes.WalkingIterator;
import com.sun.org.apache.xpath.internal.compiler.Compiler;
import com.sun.org.apache.xpath.internal.res.XPATHMessages;
import java.util.Vector;
import javax.xml.transform.TransformerException;

public class AxesWalker
extends PredicatedNodeTest
implements Cloneable,
PathComponent,
ExpressionOwner {
    private DTM m_dtm;
    transient int m_root = -1;
    private transient int m_currentNode = -1;
    transient boolean m_isFresh;
    protected AxesWalker m_nextWalker;
    AxesWalker m_prevWalker;
    protected int m_axis = -1;
    protected DTMAxisTraverser m_traverser;

    public int getAnalysisBits() {
        int axis = this.getAxis();
        int bit = WalkerFactory.getAnalysisBitFromAxes(axis);
        return bit;
    }

    public int getAxis() {
        return this.m_axis;
    }

    public final int getCurrentNode() {
        return this.m_currentNode;
    }

    protected int getNextNode() {
        if (this.m_foundLast) {
            return -1;
        }
        if (this.m_isFresh) {
            this.m_currentNode = this.m_traverser.first(this.m_root);
            this.m_isFresh = false;
        } else if (-1 != this.m_currentNode) {
            this.m_currentNode = this.m_traverser.next(this.m_root, this.m_currentNode);
        }
        if (-1 == this.m_currentNode) {
            this.m_foundLast = true;
        }
        return this.m_currentNode;
    }

    public int getRoot() {
        return this.m_root;
    }

    public int nextNode() {
        int nextNode = -1;
        AxesWalker walker = this.wi().getLastUsedWalker();
        while (null != walker) {
            nextNode = walker.getNextNode();
            if (-1 == nextNode) {
                walker = walker.m_prevWalker;
                continue;
            }
            if (walker.acceptNode(nextNode) != 1) continue;
            if (null == walker.m_nextWalker) {
                this.wi().setLastUsedWalker(walker);
                break;
            }
            AxesWalker prev = walker;
            walker = walker.m_nextWalker;
            walker.setRoot(nextNode);
            walker.m_prevWalker = prev;
        }
        return nextNode;
    }

    public void detach() {
        this.m_currentNode = -1;
        this.m_dtm = null;
        this.m_traverser = null;
        this.m_isFresh = true;
        this.m_root = -1;
    }

    public boolean isDocOrdered() {
        return true;
    }

    private int returnNextNode(int n) {
        return n;
    }

    public void setRoot(int root) {
        XPathContext xctxt = this.wi().getXPathContext();
        this.m_dtm = xctxt.getDTM(root);
        this.m_traverser = this.m_dtm.getAxisTraverser(this.m_axis);
        this.m_isFresh = true;
        this.m_foundLast = false;
        this.m_root = root;
        this.m_currentNode = root;
        if (-1 == root) {
            throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_SETTING_WALKER_ROOT_TO_NULL", null));
        }
        this.resetProximityPositions();
    }

    public DTM getDTM(int node) {
        return this.wi().getXPathContext().getDTM(node);
    }

    public void setDefaultDTM(DTM dtm) {
        this.m_dtm = dtm;
    }

    public Expression getExpression() {
        return this.m_nextWalker;
    }

    public void setExpression(Expression exp) {
        exp.exprSetParent(this);
        this.m_nextWalker = (AxesWalker)exp;
    }

    public boolean deepEquals(Expression expr) {
        if (!super.deepEquals(expr)) {
            return false;
        }
        AxesWalker walker = (AxesWalker)expr;
        return this.m_axis == walker.m_axis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLastPos(XPathContext xctxt) {
        AxesWalker walker;
        int pos = this.getProximityPosition();
        try {
            walker = (AxesWalker)this.clone();
        }
        catch (CloneNotSupportedException cnse) {
            return -1;
        }
        walker.setPredicateCount(walker.getPredicateCount() - 1);
        walker.setNextWalker(null);
        walker.setPrevWalker(null);
        WalkingIterator lpi = this.wi();
        AxesWalker savedWalker = lpi.getLastUsedWalker();
        try {
            int next;
            lpi.setLastUsedWalker(walker);
            while (-1 != (next = walker.nextNode())) {
                ++pos;
            }
            Object var8_8 = null;
            lpi.setLastUsedWalker(savedWalker);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            lpi.setLastUsedWalker(savedWalker);
            throw throwable;
        }
        return pos;
    }

    public AxesWalker getNextWalker() {
        return this.m_nextWalker;
    }

    public AxesWalker getPrevWalker() {
        return this.m_prevWalker;
    }

    public void setNextWalker(AxesWalker walker) {
        this.m_nextWalker = walker;
    }

    public void setPrevWalker(AxesWalker walker) {
        this.m_prevWalker = walker;
    }

    public AxesWalker(LocPathIterator locPathIterator, int axis) {
        super(locPathIterator);
        this.m_axis = axis;
    }

    public final WalkingIterator wi() {
        return (WalkingIterator)this.m_lpi;
    }

    public void init(Compiler compiler, int opPos, int stepType) throws TransformerException {
        this.initPredicateInfo(compiler, opPos);
    }

    public Object clone() throws CloneNotSupportedException {
        AxesWalker clone = (AxesWalker)super.clone();
        return clone;
    }

    public void callVisitors(ExpressionOwner owner, XPathVisitor visitor) {
        if (visitor.visitStep(owner, this)) {
            this.callPredicateVisitors(visitor);
            if (null != this.m_nextWalker) {
                this.m_nextWalker.callVisitors(this, visitor);
            }
        }
    }

    static AxesWalker findClone(AxesWalker key, Vector cloneList) {
        if (null != cloneList) {
            int n = cloneList.size();
            int i = 0;
            while (i < n) {
                if (key == cloneList.elementAt(i)) {
                    return (AxesWalker)cloneList.elementAt(i + 1);
                }
                i += 2;
            }
        }
        return null;
    }

    AxesWalker cloneDeep(WalkingIterator cloneOwner, Vector cloneList) throws CloneNotSupportedException {
        AxesWalker clone = AxesWalker.findClone(this, cloneList);
        if (null != clone) {
            return clone;
        }
        clone = (AxesWalker)this.clone();
        clone.setLocPathIterator(cloneOwner);
        if (null != cloneList) {
            cloneList.addElement(this);
            cloneList.addElement(clone);
        }
        if (this.wi().m_lastUsedWalker == this) {
            cloneOwner.m_lastUsedWalker = clone;
        }
        if (null != this.m_nextWalker) {
            clone.m_nextWalker = this.m_nextWalker.cloneDeep(cloneOwner, cloneList);
        }
        if (null != cloneList) {
            if (null != this.m_prevWalker) {
                clone.m_prevWalker = this.m_prevWalker.cloneDeep(cloneOwner, cloneList);
            }
        } else if (null != this.m_nextWalker) {
            clone.m_nextWalker.m_prevWalker = clone;
        }
        return clone;
    }
}

