/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xpath.internal;

import com.sun.org.apache.xml.internal.dtm.DTM;
import com.sun.org.apache.xml.internal.dtm.DTMFilter;
import com.sun.org.apache.xml.internal.dtm.DTMIterator;
import com.sun.org.apache.xml.internal.dtm.DTMManager;
import com.sun.org.apache.xml.internal.utils.NodeVector;
import com.sun.org.apache.xpath.internal.XPathContext;
import com.sun.org.apache.xpath.internal.res.XPATHMessages;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeIterator;

public class NodeSetDTM
extends NodeVector
implements DTMIterator,
Cloneable {
    DTMManager m_manager;
    protected transient int m_next = 0;
    protected transient boolean m_mutable = true;
    protected transient boolean m_cacheNodes = true;
    protected int m_root = -1;
    private transient int m_last = 0;

    public int getAxis() {
        return -1;
    }

    public int getCurrentNode() {
        if (!this.m_cacheNodes) {
            throw new RuntimeException("This NodeSetDTM can not do indexing or counting functions!");
        }
        int saved = this.m_next;
        int current = this.m_next > 0 ? this.m_next - 1 : this.m_next;
        int n = current < this.m_firstFree ? this.elementAt(current) : -1;
        this.m_next = saved;
        return n;
    }

    public int getCurrentPos() {
        return this.m_next;
    }

    public int getLast() {
        return this.m_last;
    }

    public int getLength() {
        this.runTo(-1);
        return this.size();
    }

    public int getRoot() {
        if (-1 == this.m_root) {
            if (this.size() > 0) {
                return this.item(0);
            }
            return -1;
        }
        return this.m_root;
    }

    public int getWhatToShow() {
        return -17;
    }

    public int nextNode() {
        if (this.m_next < this.size()) {
            int next = this.elementAt(this.m_next);
            ++this.m_next;
            return next;
        }
        return -1;
    }

    public int previousNode() {
        if (!this.m_cacheNodes) {
            throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_NODESETDTM_CANNOT_ITERATE", null));
        }
        if (this.m_next - 1 > 0) {
            --this.m_next;
            return this.elementAt(this.m_next);
        }
        return -1;
    }

    public int size() {
        return super.size();
    }

    public void detach() {
    }

    public void removeAllElements() {
        if (!this.m_mutable) {
            throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_NODESETDTM_NOT_MUTABLE", null));
        }
        super.removeAllElements();
    }

    public void reset() {
        this.m_next = 0;
    }

    public boolean getExpandEntityReferences() {
        return true;
    }

    public boolean getShouldCacheNodes() {
        return this.m_cacheNodes;
    }

    public boolean isDocOrdered() {
        return true;
    }

    public boolean isFresh() {
        return this.m_next == 0;
    }

    public boolean isMutable() {
        return this.m_mutable;
    }

    public int elementAt(int i) {
        this.runTo(i);
        return super.elementAt(i);
    }

    public int indexOf(int elem) {
        this.runTo(-1);
        return super.indexOf(elem);
    }

    public int item(int index) {
        this.runTo(index);
        return this.elementAt(index);
    }

    public void addElement(int value) {
        if (!this.m_mutable) {
            throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_NODESETDTM_NOT_MUTABLE", null));
        }
        super.addElement(value);
    }

    public void addNode(int n) {
        if (!this.m_mutable) {
            throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_NODESETDTM_NOT_MUTABLE", null));
        }
        this.addElement(n);
    }

    public void removeElementAt(int i) {
        if (!this.m_mutable) {
            throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_NODESETDTM_NOT_MUTABLE", null));
        }
        super.removeElementAt(i);
    }

    public void removeNode(int n) {
        if (!this.m_mutable) {
            throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_NODESETDTM_NOT_MUTABLE", null));
        }
        this.removeElement(n);
    }

    public void runTo(int index) {
        if (!this.m_cacheNodes) {
            throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_NODESETDTM_CANNOT_INDEX", null));
        }
        this.m_next = index >= 0 && this.m_next < this.m_firstFree ? index : this.m_firstFree - 1;
    }

    public void setCurrentPos(int i) {
        if (!this.m_cacheNodes) {
            throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_NODESETDTM_CANNOT_INDEX", null));
        }
        this.m_next = i;
    }

    public void setLast(int last) {
        this.m_last = last;
    }

    public boolean contains(int s) {
        this.runTo(-1);
        return super.contains(s);
    }

    public boolean removeElement(int s) {
        if (!this.m_mutable) {
            throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_NODESETDTM_NOT_MUTABLE", null));
        }
        return super.removeElement(s);
    }

    public int indexOf(int elem, int index) {
        this.runTo(-1);
        return super.indexOf(elem, index);
    }

    public void insertElementAt(int value, int at) {
        if (!this.m_mutable) {
            throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_NODESETDTM_NOT_MUTABLE", null));
        }
        super.insertElementAt(value, at);
    }

    public void insertNode(int n, int pos) {
        if (!this.m_mutable) {
            throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_NODESETDTM_NOT_MUTABLE", null));
        }
        this.insertElementAt(n, pos);
    }

    public void setElementAt(int node, int index) {
        if (!this.m_mutable) {
            throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_NODESETDTM_NOT_MUTABLE", null));
        }
        super.setElementAt(node, index);
    }

    public void setItem(int node, int index) {
        if (!this.m_mutable) {
            throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_NODESETDTM_NOT_MUTABLE", null));
        }
        super.setElementAt(node, index);
    }

    public void allowDetachToRelease(boolean allowRelease) {
    }

    public void setShouldCacheNodes(boolean b) {
        if (!this.isFresh()) {
            throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_CANNOT_CALL_SETSHOULDCACHENODE", null));
        }
        this.m_cacheNodes = b;
        this.m_mutable = true;
    }

    public DTM getDTM(int nodeHandle) {
        return this.m_manager.getDTM(nodeHandle);
    }

    public DTMFilter getFilter() {
        return null;
    }

    public DTMIterator cloneWithReset() throws CloneNotSupportedException {
        NodeSetDTM clone = (NodeSetDTM)this.clone();
        clone.reset();
        return clone;
    }

    public NodeSetDTM(DTMIterator ni) {
        this.m_manager = ni.getDTMManager();
        this.m_root = ni.getRoot();
        this.addNodes(ni);
    }

    /*
     * WARNING - void declaration
     */
    public void addNodes(DTMIterator iterator) {
        if (!this.m_mutable) {
            throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_NODESETDTM_NOT_MUTABLE", null));
        }
        if (null != iterator) {
            int obj;
            while (-1 != (obj = iterator.nextNode())) {
                void var2_2;
                this.addElement((int)var2_2);
            }
        }
    }

    public DTMManager getDTMManager() {
        return this.m_manager;
    }

    public NodeSetDTM(int blocksize, int dummy, DTMManager dtmManager) {
        super(blocksize);
        this.m_manager = dtmManager;
    }

    public NodeSetDTM(int node, DTMManager dtmManager) {
        this.m_manager = dtmManager;
        this.addNode(node);
    }

    public NodeSetDTM(DTMManager dtmManager) {
        this.m_manager = dtmManager;
    }

    public void appendNodes(NodeVector nodes) {
        if (!this.m_mutable) {
            throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_NODESETDTM_NOT_MUTABLE", null));
        }
        super.appendNodes(nodes);
    }

    public NodeSetDTM(NodeSetDTM nodelist) {
        this.m_manager = nodelist.getDTMManager();
        this.m_root = nodelist.getRoot();
        this.addNodes(nodelist);
    }

    public int addNodeInDocOrder(int node, XPathContext support) {
        if (!this.m_mutable) {
            throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_NODESETDTM_NOT_MUTABLE", null));
        }
        return this.addNodeInDocOrder(node, true, support);
    }

    public int addNodeInDocOrder(int node, boolean test, XPathContext support) {
        if (!this.m_mutable) {
            throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_NODESETDTM_NOT_MUTABLE", null));
        }
        int insertIndex = -1;
        if (test) {
            int size = this.size();
            int i = size - 1;
            while (i >= 0) {
                int child = this.elementAt(i);
                if (child == node) {
                    i = -2;
                    break;
                }
                DTM dtm = support.getDTM(node);
                if (!dtm.isNodeAfter(node, child)) break;
                --i;
            }
            if (i != -2) {
                insertIndex = i + 1;
                this.insertElementAt(node, insertIndex);
            }
        } else {
            insertIndex = this.size();
            boolean foundit = false;
            int i = 0;
            while (i < insertIndex) {
                if (i == node) {
                    foundit = true;
                    break;
                }
                ++i;
            }
            if (!foundit) {
                this.addElement(node);
            }
        }
        return insertIndex;
    }

    public Object clone() throws CloneNotSupportedException {
        NodeSetDTM clone = (NodeSetDTM)super.clone();
        return clone;
    }

    public void setRoot(int context, Object environment) {
    }

    public void setEnvironment(Object environment) {
    }

    /*
     * Unable to fully structure code
     */
    public void addNodesInDocOrder(DTMIterator iterator, XPathContext support) {
        if (this.m_mutable) ** GOTO lbl5
        throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_NODESETDTM_NOT_MUTABLE", null));
lbl-1000:
        // 1 sources

        {
            this.addNodeInDocOrder((int)var3_3, support);
lbl5:
            // 2 sources

            ** while (-1 != (node = iterator.nextNode()))
        }
lbl6:
        // 1 sources

    }

    public NodeSetDTM(NodeList nodeList, XPathContext xctxt) {
        this.m_manager = xctxt.getDTMManager();
        int n = nodeList.getLength();
        int i = 0;
        while (i < n) {
            Node node = nodeList.item(i);
            int handle = xctxt.getDTMHandleFromNode(node);
            this.addNode(handle);
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public NodeSetDTM(NodeIterator iterator, XPathContext xctxt) {
        Node node;
        this.m_manager = xctxt.getDTMManager();
        while (null != (node = iterator.nextNode())) {
            void var3_3;
            int handle = xctxt.getDTMHandleFromNode((Node)var3_3);
            this.addNodeInDocOrder(handle, xctxt);
        }
    }
}

