/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.xml;

import edu.berkeley.guir.lib.xml.XmlParseException;
import java.io.StringReader;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlMap
implements Map {
    public static final String ROOT = "ROOT";
    static SAXParserFactory factory;
    static SAXParser parser;
    Map mapAttr = new LinkedHashMap();
    boolean flagRoot = false;

    private static void init() throws Exception {
        factory = SAXParserFactory.newInstance();
        parser = factory.newSAXParser();
    }

    public XmlMap(String str) throws XmlParseException {
        try {
            XmlMap.init();
            parser.parse(new InputSource(new StringReader(str)), (DefaultHandler)new XmlParserHandler());
        }
        catch (Exception e) {
            throw new XmlParseException(e);
        }
    }

    public void clear() {
        this.mapAttr.clear();
    }

    public boolean containsKey(Object key) {
        return this.mapAttr.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.mapAttr.containsValue(value);
    }

    public Set entrySet() {
        return this.mapAttr.entrySet();
    }

    public boolean equals(Object obj) {
        return obj.hashCode() == this.hashCode();
    }

    public Object get(Object obj) {
        return this.mapAttr.get(obj);
    }

    public boolean isEmpty() {
        return this.mapAttr.isEmpty();
    }

    public Set keySet() {
        return this.mapAttr.keySet();
    }

    public Object put(Object key, Object value) {
        return this.mapAttr.put(key, value);
    }

    public void putAll(Map newMap) {
        this.mapAttr.putAll(newMap);
    }

    public Object remove(Object key) {
        return this.mapAttr.remove(key);
    }

    public int size() {
        return this.mapAttr.size();
    }

    public Collection values() {
        return this.mapAttr.values();
    }

    public String toString() {
        return this.mapAttr.toString();
    }

    public String toXml() {
        StringBuffer strbuf = new StringBuffer();
        Iterator it = this.keySet().iterator();
        strbuf.append("<");
        strbuf.append(this.mapAttr.get(ROOT));
        strbuf.append(" ");
        while (it.hasNext()) {
            String strKey = it.next().toString();
            if (ROOT.equals(strKey)) continue;
            strbuf.append(strKey);
            strbuf.append("=");
            strbuf.append(this.get(strKey));
            strbuf.append(" ");
        }
        strbuf.append("/>");
        return strbuf.toString();
    }

    public static String getTestInstanceAAA() {
        String strVal = "<Tag key1=\"val1\" key2=\"val2\" />";
        return strVal;
    }

    public static void main(String[] argv) throws Exception {
        System.out.println(new XmlMap(XmlMap.getTestInstanceAAA()));
        System.out.println(new XmlMap(XmlMap.getTestInstanceAAA()).toXml());
    }

    class XmlParserHandler
    extends DefaultHandler {
        XmlParserHandler() {
        }

        public void startElement(String uri, String localName, String elementName, Attributes attr) throws SAXException {
            if (!XmlMap.this.flagRoot) {
                XmlMap.this.put(XmlMap.ROOT, elementName);
                XmlMap.this.flagRoot = true;
            }
            int len = attr.getLength();
            int i = 0;
            while (i < len) {
                XmlMap.this.put(attr.getQName(i), attr.getValue(i));
                ++i;
            }
        }
    }
}

