/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.web;

import edu.berkeley.guir.lib.io.IOLib;
import edu.berkeley.guir.lib.web.WebBrowserFrame;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class WebLib {
    public static final String SETTINGS_FILE = "weblib.txt";
    public static final String SETTINGS_DIR = ".weblib";
    private static final Cursor CURSOR_HAND = new Cursor(12);
    private static final Cursor CURSOR_DEFAULT = new Cursor(0);
    static WebBrowserFrame web;
    static PropertyChangeListener webPageChangeListener;
    static boolean flagLoaded;

    private WebLib() {
    }

    private static void initInternalWebBrowserFrame(int width, int height) {
        if (web == null) {
            web = new WebBrowserFrame();
            web.setSize(width, height);
            web.addPropertyChangeListener("NEW_PAGE_LOADED_EVENT", new InternalWebPageChangeListener());
            web.setState(1);
        }
    }

    public static void openUrl(Component parent, String url) {
        String strOS;
        JFrame frame = null;
        if (parent == null) {
            frame = new JFrame();
            parent = frame;
        }
        if ((strOS = System.getProperty("os.name")).indexOf("Windows") >= 0) {
            try {
                Runtime.getRuntime().exec("cmd /c start " + url);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        boolean flagSave = false;
        String strBrowser = WebLib.loadBrowserSettings();
        if (strBrowser == null) {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle("Choose the browser to use:");
            fileChooser.setDialogType(0);
            int returnVal = fileChooser.showOpenDialog(parent);
            if (returnVal != 0) {
                return;
            }
            File f = fileChooser.getSelectedFile();
            if (f != null) {
                strBrowser = f.getPath();
                flagSave = true;
            }
        }
        if (strBrowser != null) {
            try {
                Runtime.getRuntime().exec(new String[]{strBrowser, url});
                if (flagSave) {
                    WebLib.saveBrowserSettings(strBrowser);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(parent, "Error in loading browser: " + e.toString(), "Error", 0);
            }
        }
        if (frame != null) {
            frame.dispose();
        }
    }

    protected static String loadBrowserSettings() {
        try {
            File fSettings = new File(WebLib.getBrowserSettingsFileName());
            if (!fSettings.exists()) {
                return null;
            }
            FileReader frdr = new FileReader(fSettings);
            StringBuffer strbuf = IOLib.readAll(frdr);
            File fBrowser = new File(strbuf.toString());
            if (fBrowser.exists()) {
                return strbuf.toString();
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected static void saveBrowserSettings(String str) {
        try {
            File f = new File(WebLib.getBrowserSettingsDirectory());
            if (!f.exists()) {
                f.mkdir();
            }
            FileWriter fwtr = new FileWriter(WebLib.getBrowserSettingsFileName());
            fwtr.write(str);
            fwtr.flush();
            fwtr.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static String getBrowserSettingsFileName() {
        return String.valueOf(WebLib.getBrowserSettingsDirectory()) + SETTINGS_FILE;
    }

    protected static String getBrowserSettingsDirectory() {
        String strHome = System.getProperty("user.home");
        String strDir = String.valueOf(strHome) + File.separatorChar + SETTINGS_DIR + File.separatorChar;
        return strDir;
    }

    public static JLabel createLinkLabel(String strUrl) {
        return WebLib.createLinkLabel(strUrl, strUrl);
    }

    public static JLabel createLinkLabel(String strUrl, String strText) {
        JLabel lbl = new JLabel("<HTML><BODY><A HREF=\"" + strUrl + "\">" + strText + "</A></BODY></HTML>");
        lbl.addMouseListener(new LinkListener(lbl, strUrl));
        return lbl;
    }

    public static Image toImage(String strUrl) throws MalformedURLException {
        return WebLib.toImage(new URL(strUrl));
    }

    public static Image toImage(String strUrl, int bwidth, int bheight, int imgwidth, int imgheight) throws MalformedURLException {
        return WebLib.toImage(new URL(strUrl), bwidth, bheight, imgwidth, imgheight);
    }

    public static Image toImage(URL url) {
        return WebLib.toImage(url, 600, 800, 150, 200);
    }

    public static synchronized Image toImage(URL url, int bwidth, int bheight, int imgwidth, int imgheight) {
        BufferedImage bimg = new BufferedImage(imgwidth, imgheight, 13);
        Graphics2D g = bimg.createGraphics();
        int tries = 0;
        g.clipRect(0, 0, imgwidth, imgheight);
        AffineTransform tx = AffineTransform.getScaleInstance((float)imgwidth / (float)bwidth, (float)imgheight / (float)bheight);
        g.transform(tx);
        HashMap<RenderingHints.Key, Object> hints = new HashMap<RenderingHints.Key, Object>();
        hints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        hints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        hints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        hints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.setRenderingHints(hints);
        WebLib.initInternalWebBrowserFrame(bwidth, bheight);
        web.setVisible(true);
        if (!url.toString().equals(web.getCurrentUrl())) {
            web.goToUrl(url);
        }
        flagLoaded = false;
        while (!flagLoaded && tries < 10) {
            try {
                Thread.sleep(750L);
                ++tries;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        web.paint(g);
        web.setVisible(false);
        return bimg;
    }

    private static void runTestAAA() throws Exception {
        JFrame f = new JFrame("test");
        URL url = new URL("http://www.cs.berkeley.edu/");
        f.setSize(600, 800);
        f.getContentPane().add(new JLabel(new ImageIcon(WebLib.toImage(url))));
        f.setVisible(true);
    }

    private static void runTestBBB() {
        WebLib.openUrl(null, "http://developer.apple.com/java/");
    }

    public static void main(String[] argv) throws Exception {
        WebLib.runTestBBB();
    }

    public static class LinkListener
    extends MouseAdapter {
        String strUrl;
        JComponent comp;

        public LinkListener(JComponent aComp, String aUrl) {
            this.comp = aComp;
            this.strUrl = aUrl;
        }

        public void setUrl(String aUrl) {
            this.strUrl = aUrl;
        }

        public void mouseEntered(MouseEvent evt) {
            this.comp.setCursor(CURSOR_HAND);
        }

        public void mouseExited(MouseEvent evt) {
            this.comp.setCursor(CURSOR_DEFAULT);
        }

        public void mousePressed(MouseEvent evt) {
            WebLib.openUrl(this.comp, this.strUrl);
        }
    }

    static class InternalWebPageChangeListener
    implements PropertyChangeListener {
        InternalWebPageChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            flagLoaded = true;
        }
    }
}

