/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.web;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.EmptyStackException;
import java.util.Stack;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class WebBrowserPanel
extends JPanel {
    public static final String NEW_PAGE_LOADED_EVENT = "NEW_PAGE_LOADED_EVENT";
    WebViewPane web;
    JScrollPane view;
    JButton buttonForward;
    JButton buttonBack;
    JButton buttonReload;
    JTextField textUrl;
    Stack stackBackUrl = new Stack();
    Stack stackForwardUrl = new Stack();
    String strCurrentUrl;
    String strLastUrl;

    public WebBrowserPanel() {
        JPanel topPanel = new JPanel(new BorderLayout());
        this.web = new WebViewPane();
        this.view = new JScrollPane(this.web);
        this.web.addHyperlinkListener(new InternalHyperlinkListener(this.web));
        this.setLayout(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        this.buttonBack = new JButton("  Back  ");
        this.buttonForward = new JButton("Forward");
        this.buttonReload = new JButton(" Reload ");
        this.textUrl = new JTextField("http://", 40);
        this.buttonBack.addActionListener(new BackButtonListener());
        this.buttonBack.setEnabled(false);
        this.buttonForward.addActionListener(new ForwardButtonListener());
        this.buttonForward.setEnabled(false);
        this.buttonReload.addActionListener(new ReloadButtonListener());
        this.buttonReload.setEnabled(false);
        this.textUrl.addActionListener(new TextActionListener());
        buttonPanel.add(this.buttonBack);
        buttonPanel.add(this.buttonForward);
        buttonPanel.add(this.buttonReload);
        buttonPanel.add(new JLabel("Address:"));
        topPanel.add((Component)buttonPanel, "West");
        topPanel.add((Component)this.textUrl, "Center");
        this.web.addPropertyChangeListener("page", new PageLoadedListener());
        this.add((Component)this.view, "Center");
        this.add((Component)topPanel, "North");
    }

    public void goBack() {
        try {
            String strCurrent = this.strCurrentUrl;
            this.strCurrentUrl = null;
            String str = (String)this.stackBackUrl.pop();
            this.stackForwardUrl.push(strCurrent);
            this.goToUrl(str);
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
    }

    public void goForward() {
        try {
            String str = (String)this.stackForwardUrl.pop();
            this.stackBackUrl.push(this.strCurrentUrl);
            this.goToUrl(str);
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
    }

    public void goToUrl(String strUrl) {
        try {
            this.goToUrl(new URL(strUrl));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void reload() {
        String str = this.strCurrentUrl;
        this.strCurrentUrl = null;
        this.goToUrl(str);
    }

    public void goToUrl(URL url) {
        try {
            String strUrl = url.toString();
            this.textUrl.setText(strUrl);
            if (strUrl.endsWith(".jpg")) {
                this.web.setContentType("image/jpg");
            } else if (strUrl.endsWith(".gif")) {
                this.web.setContentType("image/gif");
            } else {
                this.web.setContentType("text/html");
            }
            this.web.setPage(url);
            if (this.strCurrentUrl != null) {
                this.stackBackUrl.push(this.strCurrentUrl);
                this.strLastUrl = this.strCurrentUrl;
            }
            this.strCurrentUrl = strUrl;
            this.buttonBack.setEnabled(!this.stackBackUrl.empty());
            this.buttonForward.setEnabled(!this.stackForwardUrl.empty());
            this.buttonReload.setEnabled(true);
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(this, "404 File not found", "Error", 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void scrollToReference(String ref) {
        this.web.scrollToReference(ref);
    }

    public String getCurrentUrl() {
        return this.strCurrentUrl;
    }

    class InternalHyperlinkListener
    implements HyperlinkListener {
        JEditorPane web;

        public InternalHyperlinkListener(JEditorPane pane) {
            this.web = pane;
        }

        public void hyperlinkUpdate(HyperlinkEvent evt) {
            try {
                if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    WebBrowserPanel.this.goToUrl(evt.getURL());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class ForwardButtonListener
    implements ActionListener {
        ForwardButtonListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            WebBrowserPanel.this.goForward();
        }
    }

    class BackButtonListener
    implements ActionListener {
        BackButtonListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            WebBrowserPanel.this.goBack();
        }
    }

    class ReloadButtonListener
    implements ActionListener {
        ReloadButtonListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            WebBrowserPanel.this.reload();
        }
    }

    class TextActionListener
    implements ActionListener {
        TextActionListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            WebBrowserPanel.this.goToUrl(WebBrowserPanel.this.textUrl.getText());
        }
    }

    class PageLoadedListener
    implements PropertyChangeListener {
        PageLoadedListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            WebBrowserPanel.this.firePropertyChange(WebBrowserPanel.NEW_PAGE_LOADED_EVENT, WebBrowserPanel.this.strLastUrl, WebBrowserPanel.this.strCurrentUrl);
        }
    }

    static class WebViewPane
    extends JEditorPane {
        public WebViewPane() {
            this.setEditable(false);
            this.setContentType("text/html");
            this.setAutoscrolls(true);
        }

        public void scrollToReference(String reference) {
            super.scrollToReference(reference);
        }
    }
}

