/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.web;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class UrlLib {
    private static boolean doLeadingParentDirCheck(String strUrlRemainder) {
        if (strUrlRemainder.length() <= 1) {
            return true;
        }
        int startIndex = 1;
        int endIndex = 0;
        int dirCount = 0;
        while (startIndex >= 0) {
            endIndex = strUrlRemainder.indexOf("/", startIndex);
            String strDir = endIndex > 0 ? strUrlRemainder.substring(startIndex, endIndex) : strUrlRemainder.substring(startIndex);
            if (!"".equals(strDir)) {
                dirCount = "..".equals(strDir) ? --dirCount : ++dirCount;
            }
            if (dirCount < 0) {
                return false;
            }
            if (endIndex < 0) break;
            startIndex = endIndex + 1;
        }
        return true;
    }

    public static String[] resolveUrl(String strUrlRemainder) {
        String strFile = UrlLib.getPathFromRemainder(strUrlRemainder);
        String strQuery = UrlLib.getQueryFromRemainder(strUrlRemainder);
        if (!UrlLib.doLeadingParentDirCheck(strFile)) {
            throw new IllegalArgumentException("Bad URL: " + strUrlRemainder);
        }
        String[] strParsedUrl = new String[]{strFile, strQuery};
        return strParsedUrl;
    }

    private static void parseSingleQuery(String strQuery, Map map) {
        int indexEquals = strQuery.indexOf("=");
        String strKey = strQuery.substring(0, indexEquals);
        String strVal = strQuery.substring(indexEquals + 1);
        map.put(strKey, strVal);
    }

    public static Map parseQueryAsMap(String strQuery) {
        LinkedHashMap mapQuery = new LinkedHashMap();
        int indexAmp = 0;
        int lastIndexAmp = 0;
        int queryLen = strQuery.length();
        while (lastIndexAmp < queryLen) {
            indexAmp = strQuery.indexOf("&", lastIndexAmp);
            if (indexAmp < 0) {
                indexAmp = strQuery.length();
            }
            UrlLib.parseSingleQuery(strQuery.substring(lastIndexAmp, indexAmp), mapQuery);
            lastIndexAmp = indexAmp + 1;
        }
        return mapQuery;
    }

    public static String chopEnd(String strUrlRemainder) {
        int index;
        int endIndex = strUrlRemainder.length() - 1;
        if (endIndex > 0 && strUrlRemainder.charAt(endIndex) == '/') {
            --endIndex;
        }
        if ((index = strUrlRemainder.lastIndexOf("/", endIndex)) < 0) {
            throw new IllegalArgumentException("Not a valid URL remainder: " + strUrlRemainder);
        }
        return strUrlRemainder.substring(0, index + 1);
    }

    public static String getProtocol(String strUrl) {
        int index = strUrl.indexOf("://");
        if (index < 0) {
            return "";
        }
        return strUrl.substring(0, index);
    }

    public static String getAuthority(String strUrl) {
        int indexProtocol = strUrl.indexOf("://");
        if (indexProtocol < 0) {
            return "";
        }
        int indexAuthority = strUrl.indexOf("/", indexProtocol + 3);
        if (indexAuthority < 0) {
            indexAuthority = strUrl.length();
        }
        return strUrl.substring(indexProtocol + 3, indexAuthority);
    }

    public static String getUserInfo(String strUrl) {
        String strAuthority = UrlLib.getAuthority(strUrl);
        if (strAuthority.equals("")) {
            return "";
        }
        int index = strAuthority.indexOf("@");
        if (index < 0) {
            return "";
        }
        return strAuthority.substring(0, index);
    }

    public static String getHost(String strUrl) {
        String strAuthority = UrlLib.getAuthority(strUrl);
        if (strAuthority.equals("")) {
            return "";
        }
        int indexUser = strAuthority.indexOf("@");
        indexUser = indexUser < 0 ? 0 : ++indexUser;
        int indexPort = strAuthority.lastIndexOf(":");
        if (indexPort < 0) {
            indexPort = strAuthority.length();
        }
        return strAuthority.substring(indexUser, indexPort);
    }

    public static int getPort(String strUrl) {
        String strAuthority = UrlLib.getAuthority(strUrl);
        if (strAuthority.equals("")) {
            return -1;
        }
        int index = strAuthority.lastIndexOf(":");
        if (index < 0) {
            return -1;
        }
        String strPort = strAuthority.substring(index + 1);
        try {
            return Integer.parseInt(strPort);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static String getInitial(String strUrl) {
        int index = strUrl.indexOf("://");
        if (index < 0) {
            return "";
        }
        if ((index = strUrl.indexOf("/", index + 3)) < 0) {
            return strUrl;
        }
        return strUrl.substring(0, index);
    }

    public static String getRemainder(String strUrl) {
        int index = strUrl.indexOf("://");
        if (index < 0) {
            return "";
        }
        if ((index = strUrl.indexOf("/", index + 3)) < 0) {
            return "";
        }
        return strUrl.substring(index);
    }

    public static String getFile(String strUrl) {
        return UrlLib.getFileFromRemainder(UrlLib.getRemainder(strUrl));
    }

    public static String getPath(String strUrl) {
        return UrlLib.getPathFromRemainder(UrlLib.getRemainder(strUrl));
    }

    public static String getQuery(String strUrl) {
        return UrlLib.getQueryFromRemainder(UrlLib.getRemainder(strUrl));
    }

    public static Map getQueryAsMap(String strUrl) {
        String strQuery = UrlLib.getQuery(strUrl);
        return UrlLib.parseQueryAsMap(strQuery);
    }

    public static String getRef(String strUrl) {
        return UrlLib.getRefFromRemainder(UrlLib.getRemainder(strUrl));
    }

    public static String getFileFromRemainder(String strRest) {
        int index = strRest.indexOf("#");
        if (index < 0) {
            return strRest;
        }
        return strRest.substring(0, index);
    }

    public static String getPathFromRemainder(String strRest) {
        String strFile = UrlLib.getFileFromRemainder(strRest);
        int index = strFile.indexOf("?");
        if (index < 0) {
            return strFile;
        }
        return strFile.substring(0, index);
    }

    public static String getQueryFromRemainder(String strRest) {
        String strFile = UrlLib.getFileFromRemainder(strRest);
        int index = strFile.indexOf("?");
        if (index < 0) {
            return "";
        }
        return strFile.substring(index + 1);
    }

    public static Map getQueryFromRemainderAsMap(String strRest) {
        String strQuery = UrlLib.getQueryFromRemainder(strRest);
        return UrlLib.parseQueryAsMap(strQuery);
    }

    public static String getRefFromRemainder(String strRest) {
        int index = strRest.lastIndexOf("#");
        if (index < 0) {
            return "";
        }
        return strRest.substring(index + 1);
    }

    public static String toQuery(Map map) {
        Iterator it = map.keySet().iterator();
        StringBuffer strbuf = new StringBuffer();
        boolean flagFirst = true;
        while (it.hasNext()) {
            if (flagFirst) {
                flagFirst = false;
            } else {
                strbuf.append("&");
            }
            String strKey = (String)it.next();
            String strVal = (String)map.get(strKey);
            strbuf.append(strKey);
            strbuf.append("=");
            strbuf.append(strVal);
        }
        return strbuf.toString();
    }

    private static String getUrlRemainderInstanceAAA() {
        return "/";
    }

    private static String getUrlRemainderInstanceBBB() {
        return "/index.html";
    }

    private static String getUrlRemainderInstanceCCC() {
        return "/infospace";
    }

    private static String getUrlRemainderInstanceDDD() {
        return "/infospace?q=blah&r=xyzzy&s=12345";
    }

    private static String getUrlInstanceAAA() {
        return "http://jasonh@www.cs.berkeley.edu:8080/foo/bar.html#hey";
    }

    private static String getUrlInstanceBBB() {
        return "http://www.cs.berkeley.edu:8080";
    }

    private static String getUrlInstanceCCC() {
        return "http://www.cs.berkeley.edu";
    }

    private static String getUrlInstanceDDD() {
        return "http://www.cs.berkeley.edu/~jasonh/infospace?q=xyzzy&d=qwerty";
    }

    private static String getUrlInstanceEEE() {
        return "http://www.google.com/search?as_q=test&num=20&hl=en&ie=UTF-8&oe=UTF-8&btnG=Google+Search&as_epq=&as_oq=job&as_eq=dog&lr=&as_ft=i&as_filetype=&as_qdr=all&as_occt=any&as_dt=i&as_sitesearch=&safe=images";
    }

    private static String getUrlInstanceFFF() {
        return "http://localhost:8080/infospace/localuser/?q=/Tuples/ContextTuple[@dataformat='latlon'%20AND%20@datatype='location']&timespan='past 5 days'";
    }

    private static void runPrintTest(String strUrl) {
        System.out.print(String.valueOf(UrlLib.getPath(strUrl)) + " " + UrlLib.getQueryAsMap(strUrl) + "\n");
    }

    private static void runTestAAA() {
        UrlLib.runPrintTest(UrlLib.getUrlRemainderInstanceAAA());
        UrlLib.runPrintTest(UrlLib.getUrlRemainderInstanceBBB());
        UrlLib.runPrintTest(UrlLib.getUrlRemainderInstanceCCC());
        UrlLib.runPrintTest(UrlLib.getUrlRemainderInstanceDDD());
        System.out.println("1 " + UrlLib.getQueryAsMap(""));
        System.out.println("2 " + UrlLib.parseQueryAsMap(""));
    }

    private static void testSuiteAAA(String strUrl) {
        System.out.println(strUrl);
        System.out.println("i" + UrlLib.getInitial(strUrl));
        System.out.println("r" + UrlLib.getRemainder(strUrl));
        System.out.println("p" + UrlLib.getProtocol(strUrl));
        System.out.println("a" + UrlLib.getAuthority(strUrl));
        System.out.println("h" + UrlLib.getHost(strUrl));
        System.out.println("u" + UrlLib.getUserInfo(strUrl));
        System.out.println("p" + UrlLib.getPort(strUrl));
        System.out.println("f" + UrlLib.getFile(strUrl));
        System.out.println("p" + UrlLib.getPath(strUrl));
        System.out.println("q" + UrlLib.getQuery(strUrl));
        System.out.println("r" + UrlLib.getRef(strUrl));
        System.out.println("------------");
    }

    private static void runTestBBB() throws Exception {
        String strUrlAA = "http://jasonh@www.cs.berkeley.edu:8080/foo/bar.html#hey";
        String strUrlBB = "http://www.cs.berkeley.edu:8080";
        String strUrlCC = "http://www.cs.berkeley.edu";
        String strUrlDD = "http://www.cs.berkeley.edu/~jasonh/infospace?q=xyzzy&d=qwerty";
        String strUrlEE = "www.cs.berkeley.edu";
        UrlLib.testSuiteAAA(strUrlAA);
        UrlLib.testSuiteAAA(strUrlBB);
        UrlLib.testSuiteAAA(strUrlCC);
        UrlLib.testSuiteAAA(strUrlDD);
        UrlLib.testSuiteAAA(strUrlEE);
    }

    private static void runTestCCC() throws Exception {
        System.out.println(UrlLib.doLeadingParentDirCheck("/"));
        System.out.println(UrlLib.doLeadingParentDirCheck("/index.html"));
        System.out.println(UrlLib.doLeadingParentDirCheck("/server/"));
        System.out.println(UrlLib.doLeadingParentDirCheck("/server"));
        System.out.println(UrlLib.doLeadingParentDirCheck("/server/../"));
        System.out.println(UrlLib.doLeadingParentDirCheck("/server/../../"));
        System.out.println(UrlLib.doLeadingParentDirCheck("/../"));
        System.out.println(UrlLib.doLeadingParentDirCheck("/server/../.."));
    }

    private static void testParseQuery(String strUrl) {
        String strQuery = UrlLib.getQuery(strUrl);
        Map map = UrlLib.getQueryAsMap(strUrl);
        System.out.println(strQuery);
        System.out.println(map);
        System.out.println(UrlLib.toQuery(map));
        System.out.println(strQuery.equals(UrlLib.toQuery(map)));
        System.out.println("-------");
    }

    private static void runTestDDD() throws Exception {
        UrlLib.testParseQuery(UrlLib.getUrlInstanceAAA());
        UrlLib.testParseQuery(UrlLib.getUrlInstanceBBB());
        UrlLib.testParseQuery(UrlLib.getUrlInstanceCCC());
        UrlLib.testParseQuery(UrlLib.getUrlInstanceDDD());
        UrlLib.testParseQuery(UrlLib.getUrlInstanceEEE());
        UrlLib.testParseQuery(UrlLib.getUrlInstanceFFF());
    }

    public static void main(String[] argv) throws Exception {
        UrlLib.runTestDDD();
    }
}

