/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.web;

import java.io.BufferedReader;
import java.io.File;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;

public class HttpLib {
    public static final String MIME_UNKNOWN = "unknown/unknown";
    public static final String ERROR_UNKNOWN = "Unknown Error";
    static Map mapMimeTypes = new HashMap();
    static boolean flagInitialized = false;
    private static final String[] METHODS = new String[]{"GET", "POST", "DELETE", "SUBSCRIBE", "UNSUBSCRIBE", "OPTIONS", "TRACE", "HEAD", "PUT", "CONNECT"};

    private static void init() {
        if (!flagInitialized) {
            flagInitialized = true;
            mapMimeTypes.put("", "content/unknown");
            mapMimeTypes.put(".uu", "application/octet-stream");
            mapMimeTypes.put(".exe", "application/octet-stream");
            mapMimeTypes.put(".bin", "application/octet-stream");
            mapMimeTypes.put(".dms", "application/octet-stream");
            mapMimeTypes.put(".lha", "application/octet-stream");
            mapMimeTypes.put(".lzh", "application/octet-stream");
            mapMimeTypes.put(".midi", "application/midi");
            mapMimeTypes.put(".kar", "application/kar");
            mapMimeTypes.put(".mpga", "application/mpeg");
            mapMimeTypes.put(".mp2", "application/mpeg");
            mapMimeTypes.put(".mp3", "application/mpeg");
            mapMimeTypes.put(".class", "application/postscript");
            mapMimeTypes.put(".ai", "application/postscript");
            mapMimeTypes.put(".eps", "application/postscript");
            mapMimeTypes.put(".rtf", "application/rtf");
            mapMimeTypes.put(".doc", "application/msword");
            mapMimeTypes.put(".pdf", "application/pdf");
            mapMimeTypes.put(".ppt", "application/powerpoint");
            mapMimeTypes.put(".smi", "application/smil");
            mapMimeTypes.put(".sml", "application/smil");
            mapMimeTypes.put(".smil", "application/smil");
            mapMimeTypes.put(".zip", "application/zip");
            mapMimeTypes.put(".sh", "application/x-shar");
            mapMimeTypes.put(".tar", "application/x-tar");
            mapMimeTypes.put(".wav", "application/x-wav");
            mapMimeTypes.put(".js", "application/x-javascript");
            mapMimeTypes.put(".au", "audio/basic");
            mapMimeTypes.put(".snd", "audio/basic");
            mapMimeTypes.put(".wav", "audio/x-wav");
            mapMimeTypes.put(".gif", "image/gif");
            mapMimeTypes.put(".jpe", "image/jpeg");
            mapMimeTypes.put(".jpg", "image/jpeg");
            mapMimeTypes.put(".jpeg", "image/jpeg");
            mapMimeTypes.put(".png", "image/png");
            mapMimeTypes.put(".tif", "image/tiff");
            mapMimeTypes.put(".tiff", "image/tiff");
            mapMimeTypes.put(".css", "text/css");
            mapMimeTypes.put(".htm", "text/html");
            mapMimeTypes.put(".html", "text/html");
            mapMimeTypes.put(".xml", "text/xml");
            mapMimeTypes.put(".dtd", "text/xml");
            mapMimeTypes.put(".text", "text/plain");
            mapMimeTypes.put(".txt", "text/plain");
            mapMimeTypes.put(".nfo", "text/plain");
            mapMimeTypes.put(".c", "text/plain");
            mapMimeTypes.put(".cc", "text/plain");
            mapMimeTypes.put(".c++", "text/plain");
            mapMimeTypes.put(".h", "text/plain");
            mapMimeTypes.put(".pl", "text/plain");
            mapMimeTypes.put(".java", "text/plain");
            mapMimeTypes.put(".mpeg", "video/mpeg");
            mapMimeTypes.put(".mpe", "video/mpeg");
            mapMimeTypes.put(".mpg", "video/mpeg");
            mapMimeTypes.put(".avi", "video/x-msvideo");
        }
    }

    public static boolean isValidMethod(String strMethodName) {
        int i = 0;
        while (i < METHODS.length) {
            if (METHODS[i].equals(strMethodName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String getContentType(File f) {
        return f.toString();
    }

    public static String getContentType(String strFileName) {
        HttpLib.init();
        int index = strFileName.lastIndexOf(46);
        if (index <= 0) {
            return MIME_UNKNOWN;
        }
        String strExtension = strFileName.substring(index);
        String strMimeType = (String)mapMimeTypes.get(strExtension);
        if (strMimeType == null) {
            return MIME_UNKNOWN;
        }
        return strMimeType;
    }

    public static boolean isValidResponseCode(int val) {
        HttpLib.init();
        return 200 <= val && val <= 206 || 300 <= val && val <= 305 || 400 <= val && val <= 415 || 500 <= val && val <= 505;
    }

    private static String get(String str, int n) {
        int index = str.indexOf("\n");
        String strLine = index > 0 ? str.substring(0, index) : str;
        int indexAA = strLine.indexOf(" ");
        int indexBB = strLine.indexOf(" ", indexAA + 1);
        if (n == 0) {
            return strLine.substring(0, indexAA);
        }
        if (n == 1) {
            return strLine.substring(indexAA + 1, indexBB);
        }
        return strLine.substring(indexBB + 1);
    }

    public static String getRequestMethod(String str) {
        return HttpLib.get(str, 0);
    }

    public static String getRequestUri(String str) {
        return HttpLib.get(str, 1);
    }

    public static String getRequestVersion(String str) {
        return HttpLib.get(str, 2);
    }

    public static String getResponseVersion(String str) {
        return HttpLib.get(str, 0);
    }

    public static String getResponseCode(String str) {
        return HttpLib.get(str, 1);
    }

    public static String getResponseMessage(String str) {
        return HttpLib.get(str, 2);
    }

    public static Map getHeaders(String str) {
        StringReader rdr = new StringReader(str);
        BufferedReader brdr = new BufferedReader(rdr);
        boolean flagFirst = true;
        HashMap<String, String> mapHeaders = new HashMap<String, String>();
        try {
            String strLine;
            while ((strLine = brdr.readLine()) != null) {
                if (flagFirst) {
                    flagFirst = false;
                    continue;
                }
                if (!"".equals(strLine)) {
                    int index = strLine.indexOf(":");
                    String strKey = strLine.substring(0, index);
                    String strVal = strLine.substring(index + 1).trim();
                    mapHeaders.put(strKey, strVal);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapHeaders;
    }

    private static String getTestInstanceAAA() {
        return "HTTP/1.1 302 Found\ncontent-length: 237\nconnection: close\nset-cookie: skin=; domain=.amazon.com; path=/; expires=Wed, 01-Aug-01 12:00:00 GMT\ncontent-type: text/html; charset=iso-8859-1\nlocation: http://www.amazon.com:80/exec/obidos/subst/home/home.html\nserver: Stronghold/2.4.2 Apache/1.3.6 C2NetEU/2412 (Unix) amarewrite/0.1 mod_fastcgi/2.2.12\ndate: Sun, 25 Jan 2004 17:53:05 GMT\n";
    }

    private static String getTestInstanceBBB() {
        return "HTTP/1.1 302 Moved Temporarily\ncontent-length: 0\nconnection: close\ncontent-type: text/html\nlocation: http://www.cnn.com/\nserver: Netscape-Enterprise/6.1 AOL\ndate: Sun, 25 Jan 2004 17:54:43 GMT\n";
    }

    private static void testHeaders(String str) {
        System.out.println(HttpLib.getResponseVersion(str));
        System.out.println(HttpLib.getResponseCode(str));
        System.out.println(HttpLib.getResponseMessage(str));
        System.out.println(HttpLib.getHeaders(str));
    }

    private static void runTestAAA() {
        HttpLib.testHeaders(HttpLib.getTestInstanceAAA());
        HttpLib.testHeaders(HttpLib.getTestInstanceBBB());
    }

    public static void main(String[] argv) {
        HttpLib.runTestAAA();
    }
}

