/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.web;

import java.util.HashMap;
import java.util.Map;

public class HttpConstants {
    public static final String[] DEFAULT_FILES = new String[]{"index.html", "index.htm"};
    public static final String HTTP_VERSION_0_9 = "HTTP/0.9";
    public static final String HTTP_VERSION_1_0 = "HTTP/1.0";
    public static final String HTTP_VERSION_1_1 = "HTTP/1.1";
    public static final String DEFAULT_HTTP_VERSION = "HTTP/1.0";
    public static final int HTTP_OK = 200;
    public static final int HTTP_CREATED = 201;
    public static final int HTTP_ACCEPTED = 202;
    public static final int HTTP_NOT_AUTHORITATIVE = 203;
    public static final int HTTP_NO_CONTENT = 204;
    public static final int HTTP_RESET = 205;
    public static final int HTTP_PARTIAL = 206;
    public static final int HTTP_MULT_CHOICE = 300;
    public static final int HTTP_MOVED_PERM = 301;
    public static final int HTTP_MOVED_TEMP = 302;
    public static final int HTTP_SEE_OTHER = 303;
    public static final int HTTP_NOT_MODIFIED = 304;
    public static final int HTTP_USE_PROXY = 305;
    public static final int HTTP_BAD_REQUEST = 400;
    public static final int HTTP_UNAUTHORIZED = 401;
    public static final int HTTP_PAYMENT_REQUIRED = 402;
    public static final int HTTP_FORBIDDEN = 403;
    public static final int HTTP_NOT_FOUND = 404;
    public static final int HTTP_BAD_METHOD = 405;
    public static final int HTTP_NOT_ACCEPTABLE = 406;
    public static final int HTTP_PROXY_AUTH = 407;
    public static final int HTTP_CLIENT_TIMEOUT = 408;
    public static final int HTTP_CONFLICT = 409;
    public static final int HTTP_GONE = 410;
    public static final int HTTP_LENGTH_REQUIRED = 411;
    public static final int HTTP_PRECON_FAILED = 412;
    public static final int HTTP_ENTITY_TOO_LARGE = 413;
    public static final int HTTP_REQ_TOO_LONG = 414;
    public static final int HTTP_UNSUPPORTED_TYPE = 415;
    public static final int HTTP_SERVER_ERROR = 500;
    public static final int HTTP_NOT_IMPLEMENTED = 501;
    public static final int HTTP_BAD_GATEWAY = 502;
    public static final int HTTP_UNAVAILABLE = 503;
    public static final int HTTP_GATEWAY_TIMEOUT = 504;
    public static final int HTTP_VERSION = 505;
    public static final String METHOD_GET = "GET";
    public static final String METHOD_POST = "POST";
    public static final String METHOD_DELETE = "DELETE";
    public static final String METHOD_HEAD = "HEAD";
    public static final String METHOD_PUT = "PUT";
    public static final String METHOD_TRACE = "TRACE";
    public static final String METHOD_OPTIONS = "OPTIONS";
    public static final String METHOD_SUBSCRIBE = "SUBSCRIBE";
    public static final String METHOD_UNSUBSCRIBE = "UNSUBSCRIBE";
    public static final String METHOD_NOTIFY = "NOTIFY";
    public static final String REQUEST_METHOD = "METHOD";
    public static final String REQUEST_VERSION = "VERSION";
    public static final String REQUEST_URL = "URL";
    public static final String REQUEST_URL_FILE = "FILE";
    public static final String REQUEST_URL_QUERY = "QUERY";
    public static final String REQUEST_ADDRESS = "ADDRESS";
    public static final String REQUEST_HOST = "host";
    public static final String REQUEST_USER_AGENT = "user-agent";
    public static final String REQUEST_ACCEPT = "accept";
    public static final String REQUEST_ACCEPT_LANGUAGE = "accept-language";
    public static final String REQUEST_ACCEPT_ENCODING = "accept-encoding";
    public static final String REQUEST_ACCEPT_CHARSET = "accept-charset";
    public static final String REQUEST_KEEP_ALIVE = "keep-alive";
    public static final String REQUEST_CONNECTION = "connection";
    public static final String REQUEST_CACHE_CONTROL = "cache-control";
    public static final String REQUEST_CONTENT_LENGTH = "content-length";
    public static final String REQUEST_CONTENT_TYPE = "content-type";
    public static final String RESPONSE_VERSION = "VERSION";
    public static final String RESPONSE_CODE = "RESPONSE-CODE";
    public static final String RESPONSE_MSG = "RESPONSE-MSG";
    public static final String RESPONSE_DATE = "date";
    public static final String RESPONSE_SERVER = "server";
    public static final String RESPONSE_LAST_MODIFIED = "last modified";
    public static final String RESPONSE_CONTENT_LENGTH = "content-length";
    public static final String RESPONSE_CONTENT_TYPE = "content-type";
    public static final String RESPONSE_SET_COOKIE = "set-cookie";
    private static Map mapMsg = new HashMap();
    private static boolean flagInit = false;

    private static void init() {
        if (flagInit) {
            return;
        }
        flagInit = true;
        mapMsg.put(new Integer(200), "OK");
        mapMsg.put(new Integer(201), "Created");
        mapMsg.put(new Integer(202), "Accepted");
        mapMsg.put(new Integer(203), "Not authoritative");
        mapMsg.put(new Integer(204), "No content");
        mapMsg.put(new Integer(205), "Reset");
        mapMsg.put(new Integer(206), "Partial content");
        mapMsg.put(new Integer(300), "Multiple choices");
        mapMsg.put(new Integer(301), "Moved permanently");
        mapMsg.put(new Integer(302), "Moved temporarily");
        mapMsg.put(new Integer(303), "See other");
        mapMsg.put(new Integer(304), "Not modified");
        mapMsg.put(new Integer(305), "Use proxy");
        mapMsg.put(new Integer(400), "Bad request");
        mapMsg.put(new Integer(401), "Unauthorized");
        mapMsg.put(new Integer(402), "Payment required");
        mapMsg.put(new Integer(403), "Forbidden");
        mapMsg.put(new Integer(404), "Not found");
        mapMsg.put(new Integer(405), "Bad method");
        mapMsg.put(new Integer(406), "Not acceptable");
        mapMsg.put(new Integer(407), "Proxy authentication required");
        mapMsg.put(new Integer(408), "Client timeout");
        mapMsg.put(new Integer(409), "Conflict");
        mapMsg.put(new Integer(410), "Gone");
        mapMsg.put(new Integer(411), "Content-length required");
        mapMsg.put(new Integer(412), "Precondition failed");
        mapMsg.put(new Integer(413), "Entity too large");
        mapMsg.put(new Integer(414), "Request-URI too long");
        mapMsg.put(new Integer(415), "Unsupported media type");
        mapMsg.put(new Integer(500), "Server error");
        mapMsg.put(new Integer(501), "Not implemented");
        mapMsg.put(new Integer(502), "Bad gateway");
        mapMsg.put(new Integer(503), "Unavailable");
        mapMsg.put(new Integer(504), "Gateway timeout");
        mapMsg.put(new Integer(505), "Version not supported");
    }

    public static String getReturnMessage(int httpResponseCode) {
        HttpConstants.init();
        String strMsg = (String)mapMsg.get(new Integer(httpResponseCode));
        if (strMsg == null) {
            strMsg = "Unknown";
        }
        return strMsg;
    }

    public static String getReturnMessage(String strResponseCode) {
        try {
            return HttpConstants.getReturnMessage(Integer.parseInt(strResponseCode));
        }
        catch (Exception e) {
            return "Unknown";
        }
    }
}

