/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.web;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class HtmlCodec {
    static boolean flagInit = false;
    static Map mapString2Code = new HashMap();
    static Map mapCode2String = new HashMap();

    private static void init() {
        if (flagInit) {
            return;
        }
        flagInit = true;
        mapString2Code.put("&", "&amp;");
        mapString2Code.put("<", "&lt;");
        mapString2Code.put(">", "&gt;");
        mapString2Code.put("\"", "&quot;");
        mapString2Code.put("\u0083", "&#131;");
        mapString2Code.put("\u0084", "&#132;");
        mapString2Code.put("\u0085", "&#133;");
        mapString2Code.put("\u0086", "&#134;");
        mapString2Code.put("\u0087", "&#135;");
        mapString2Code.put("\u0089", "&#137;");
        mapString2Code.put("\u008a", "&#138;");
        mapString2Code.put("\u008b", "&#139;");
        mapString2Code.put("\u008c", "&#140;");
        mapString2Code.put("\u0091", "&#145;");
        mapString2Code.put("\u0092", "&#146;");
        mapString2Code.put("\u0093", "&#147;");
        mapString2Code.put("\u0094", "&#148;");
        mapString2Code.put("\u0095", "&#149;");
        mapString2Code.put("\u0096", "&#150;");
        mapString2Code.put("\u0097", "&#151;");
        mapString2Code.put("\u0099", "&#153;");
        mapString2Code.put("\u009a", "&#154;");
        mapString2Code.put("\u009b", "&#155;");
        mapString2Code.put("\u009c", "&#156;");
        mapString2Code.put("\u009f", "&#159;");
        mapString2Code.put("\u00a0", "nbsp;");
        mapString2Code.put("\u00a1", "&iexcl;");
        mapString2Code.put("\u00a2", "&cent;");
        mapString2Code.put("\u00a3", "&pound;");
        mapString2Code.put("\u00a4", "&curren;");
        mapString2Code.put("\u00a5", "&yen;");
        mapString2Code.put("\u00a6", "&brvbar;");
        mapString2Code.put("\u00a7", "&sect;");
        mapString2Code.put("\u00a8", "&uml;");
        mapString2Code.put("\u00a9", "&copy;");
        mapString2Code.put("\u00aa", "&ordf;");
        mapString2Code.put("\u00ab", "&laquo;");
        mapString2Code.put("\u00ac", "&not;");
        mapString2Code.put("\u00ad", "&shy;");
        mapString2Code.put("\u00ae", "&reg;");
        mapString2Code.put("\u00af", "&macr;");
        mapString2Code.put("\u00b0", "&deg;");
        mapString2Code.put("\u00b1", "&plusmn;");
        mapString2Code.put("\u00b2", "&sup2;");
        mapString2Code.put("\u00b3", "&sup3;");
        mapString2Code.put("\u00b4", "&acute;");
        mapString2Code.put("\u00b5", "&micro;");
        mapString2Code.put("\u00b6", "&para;");
        mapString2Code.put("\u00b7", "&middot;");
        mapString2Code.put("\u00b8", "&cedil;");
        mapString2Code.put("\u00b9", "&sup1;");
        mapString2Code.put("\u00ba", "&ordm;");
        mapString2Code.put("\u00bb", "&raquo;");
        mapString2Code.put("\u00bc", "&frac14;");
        mapString2Code.put("\u00bd", "&frac12;");
        mapString2Code.put("\u00be", "&frac34;");
        mapString2Code.put("\u00bf", "&iquest;");
        mapString2Code.put("\u00c0", "&Agrave;");
        mapString2Code.put("\u00c1", "&Aacute;");
        mapString2Code.put("\u00c2", "&Acirc;");
        mapString2Code.put("\u00c3", "&Atilde;");
        mapString2Code.put("\u00c4", "&Auml;");
        mapString2Code.put("\u00c5", "&Aring;");
        mapString2Code.put("\u00c6", "&AElig;");
        mapString2Code.put("\u00c7", "&Ccedil;");
        mapString2Code.put("\u00c8", "&Egrave;");
        mapString2Code.put("\u00c9", "&Eacute;");
        mapString2Code.put("\u00ca", "&Ecirc;");
        mapString2Code.put("\u00cb", "&Euml;");
        mapString2Code.put("\u00cc", "&Igrave;");
        mapString2Code.put("\u00cd", "&Iacute;");
        mapString2Code.put("\u00ce", "&Icirc;");
        mapString2Code.put("\u00cf", "&Iuml;");
        mapString2Code.put("\u00d0", "&ETH;");
        mapString2Code.put("\u00d1", "&Ntilde;");
        mapString2Code.put("\u00d2", "&Ograve;");
        mapString2Code.put("\u00d3", "&Oacute;");
        mapString2Code.put("\u00d4", "&Ocirc;");
        mapString2Code.put("\u00d5", "&Otilde;");
        mapString2Code.put("\u00d6", "&Ouml;");
        mapString2Code.put("\u00d7", "&times;");
        mapString2Code.put("\u00d8", "&Oslash;");
        mapString2Code.put("\u00d9", "&Ugrave;");
        mapString2Code.put("\u00da", "&Uacute;");
        mapString2Code.put("\u00db", "&Ucirc;");
        mapString2Code.put("\u00dc", "&Uuml;");
        mapString2Code.put("\u00dd", "&Yacute;");
        mapString2Code.put("\u00de", "&THORN;");
        mapString2Code.put("\u00df", "&szlig;");
        mapString2Code.put("\u00e0", "&agrave;");
        mapString2Code.put("\u00e1", "&aacute;");
        mapString2Code.put("\u00e2", "&acirc;");
        mapString2Code.put("\u00e3", "&atilde;");
        mapString2Code.put("\u00e4", "&auml;");
        mapString2Code.put("\u00e5", "&aring;");
        mapString2Code.put("\u00e6", "&aelig;");
        mapString2Code.put("\u00e7", "&ccedil;");
        mapString2Code.put("\u00e8", "&egrave;");
        mapString2Code.put("\u00e9", "&eacute;");
        mapString2Code.put("\u00ea", "&ecirc;");
        mapString2Code.put("\u00eb", "&euml;");
        mapString2Code.put("\u00ec", "&igrave;");
        mapString2Code.put("\u00ed", "&iacute;");
        mapString2Code.put("\u00ee", "&icirc;");
        mapString2Code.put("\u00ef", "&iuml;");
        mapString2Code.put("\u00f0", "&eth;");
        mapString2Code.put("\u00f1", "&ntilde;");
        mapString2Code.put("\u00f2", "&ograve;");
        mapString2Code.put("\u00f3", "&oacute;");
        mapString2Code.put("\u00f4", "&ocirc;");
        mapString2Code.put("\u00f5", "&otilde;");
        mapString2Code.put("\u00f6", "&ouml;");
        mapString2Code.put("\u00f7", "&divide;");
        mapString2Code.put("\u00f8", "&oslash;");
        mapString2Code.put("\u00f9", "&ugrave;");
        mapString2Code.put("\u00fa", "&uacute;");
        mapString2Code.put("\u00fb", "&ucirc;");
        mapString2Code.put("\u00fc", "&uuml;");
        mapString2Code.put("\u00fd", "&yacute;");
        mapString2Code.put("\u00fe", "&thorn;");
        mapString2Code.put("\u00ff", "&yuml;");
        mapString2Code.put("\u0152", "&OElig;");
        mapString2Code.put("\u0153", "&oelig;");
        mapString2Code.put("\u0160", "&Scaron;");
        mapString2Code.put("\u0161", "&scaron;");
        mapString2Code.put("\u0178", "&Yuml;");
        mapString2Code.put("\u0192", "&fnof;");
        mapString2Code.put("\u02c6", "&circ;");
        mapString2Code.put("\u02dc", "&tilde;");
        mapString2Code.put("\u0336", "&bull;");
        mapString2Code.put("\u0337", "&hellip;");
        mapString2Code.put("\u0338", "&prime;");
        mapString2Code.put("\u0338", "&Prime;");
        mapString2Code.put("\u0339", "&oline;");
        mapString2Code.put("\u033a", "&frasl;");
        mapString2Code.put("\u034e", "&image;");
        mapString2Code.put("\u034f", "&weierp;");
        mapString2Code.put("\u034f", "&real;");
        mapString2Code.put("\u0350", "&trade;");
        mapString2Code.put("\u0352", "&alefsym;");
        mapString2Code.put("\u035b", "&larr;");
        mapString2Code.put("\u035b", "&uarr;");
        mapString2Code.put("\u035b", "&rarr;");
        mapString2Code.put("\u035b", "&darr;");
        mapString2Code.put("\u035b", "&harr;");
        mapString2Code.put("\u035e", "&crarr;");
        mapString2Code.put("\u0361", "&lArr;");
        mapString2Code.put("\u0361", "&uArr;");
        mapString2Code.put("\u0361", "&rArr;");
        mapString2Code.put("\u0361", "&dArr;");
        mapString2Code.put("\u0362", "&hArr;");
        mapString2Code.put("\u0366", "&forall;");
        mapString2Code.put("\u0366", "&part;");
        mapString2Code.put("\u0366", "&exist;");
        mapString2Code.put("\u0366", "&empty;");
        mapString2Code.put("\u0367", "&nabla;");
        mapString2Code.put("\u0367", "&isin;");
        mapString2Code.put("\u0367", "&notin;");
        mapString2Code.put("\u0367", "&ni;");
        mapString2Code.put("\u0367", "&prod;");
        mapString2Code.put("\u0368", "&sum;");
        mapString2Code.put("\u0368", "&minus;");
        mapString2Code.put("\u0368", "&lowast;");
        mapString2Code.put("\u0369", "&radic;");
        mapString2Code.put("\u0369", "&prop;");
        mapString2Code.put("\u0369", "&infin;");
        mapString2Code.put("\u0369", "&ang;");
        mapString2Code.put("\u036a", "&and;");
        mapString2Code.put("\u036a", "&or;");
        mapString2Code.put("\u036a", "&cap;");
        mapString2Code.put("\u036a", "&cup;");
        mapString2Code.put("\u036a", "&int;");
        mapString2Code.put("\u036b", "&there4;");
        mapString2Code.put("\u036c", "&sim;");
        mapString2Code.put("\u036d", "&cong;");
        mapString2Code.put("\u036d", "&asymp;");
        mapString2Code.put("\u0370", "&ne;");
        mapString2Code.put("\u0370", "&equiv;");
        mapString2Code.put("\u0370", "&le;");
        mapString2Code.put("\u0370", "&ge;");
        mapString2Code.put("\u0373", "&sub;");
        mapString2Code.put("\u0373", "&sup;");
        mapString2Code.put("\u0373", "&nsub;");
        mapString2Code.put("\u0373", "&sube;");
        mapString2Code.put("\u0373", "&supe;");
        mapString2Code.put("\u0375", "&oplus;");
        mapString2Code.put("\u0375", "&otimes;");
        mapString2Code.put("\u0376", "&perp;");
        mapString2Code.put("\u037a", "&sdot;");
        mapString2Code.put("\u0380", "&lceil;");
        mapString2Code.put("\u0380", "&rceil;");
        mapString2Code.put("\u0381", "&lfloor;");
        mapString2Code.put("\u0381", "&rfloor;");
        mapString2Code.put("\u0384", "&lang;");
        mapString2Code.put("\u0384", "&rang;");
        mapString2Code.put("\u0391", "&Alpha;");
        mapString2Code.put("\u0392", "&Beta;");
        mapString2Code.put("\u0393", "&Gamma;");
        mapString2Code.put("\u0394", "&Delta;");
        mapString2Code.put("\u0395", "&Epsilon;");
        mapString2Code.put("\u0396", "&Zeta;");
        mapString2Code.put("\u0397", "&Eta;");
        mapString2Code.put("\u0398", "&Theta;");
        mapString2Code.put("\u0399", "&Iota;");
        mapString2Code.put("\u039a", "&Kappa;");
        mapString2Code.put("\u039b", "&Lambda;");
        mapString2Code.put("\u039c", "&Mu;");
        mapString2Code.put("\u039d", "&Nu;");
        mapString2Code.put("\u039e", "&Xi;");
        mapString2Code.put("\u039f", "&Omicron;");
        mapString2Code.put("\u03a0", "&Pi;");
        mapString2Code.put("\u03a1", "&Rho;");
        mapString2Code.put("\u03a3", "&Sigma;");
        mapString2Code.put("\u03a4", "&Tau;");
        mapString2Code.put("\u03a5", "&Upsilon;");
        mapString2Code.put("\u03a6", "&Phi;");
        mapString2Code.put("\u03a7", "&Chi;");
        mapString2Code.put("\u03a8", "&Psi;");
        mapString2Code.put("\u03a9", "&Omega;");
        mapString2Code.put("\u03b1", "&alpha;");
        mapString2Code.put("\u03b2", "&beta;");
        mapString2Code.put("\u03b3", "&gamma;");
        mapString2Code.put("\u03b4", "&delta;");
        mapString2Code.put("\u03b5", "&epsilon;");
        mapString2Code.put("\u03b6", "&zeta;");
        mapString2Code.put("\u03b7", "&eta;");
        mapString2Code.put("\u03b8", "&theta;");
        mapString2Code.put("\u03b9", "&iota;");
        mapString2Code.put("\u03ba", "&kappa;");
        mapString2Code.put("\u03bb", "&lambda;");
        mapString2Code.put("\u03bc", "&mu;");
        mapString2Code.put("\u03bd", "&nu;");
        mapString2Code.put("\u03be", "&xi;");
        mapString2Code.put("\u03bf", "&omicron;");
        mapString2Code.put("\u03c0", "&pi;");
        mapString2Code.put("\u03c1", "&rho;");
        mapString2Code.put("\u03c2", "&sigmaf;");
        mapString2Code.put("\u03c3", "&sigma;");
        mapString2Code.put("\u03c4", "&tau;");
        mapString2Code.put("\u03c5", "&upsilon;");
        mapString2Code.put("\u03c6", "&phi;");
        mapString2Code.put("\u03c7", "&chi;");
        mapString2Code.put("\u03c7", "&loz;");
        mapString2Code.put("\u03c8", "&psi;");
        mapString2Code.put("\u03c9", "&omega;");
        mapString2Code.put("\u03d1", "&thetasy;");
        mapString2Code.put("\u03d2", "&upsih;");
        mapString2Code.put("\u03d6", "&piv;");
        mapString2Code.put("\u03d6", "&spades;");
        mapString2Code.put("\u03d6", "&clubs;");
        mapString2Code.put("\u03d6", "&hearts;");
        mapString2Code.put("\u03d7", "&diams;");
        mapString2Code.put("\u2002", "&ensp;");
        mapString2Code.put("\u2003", "&emsp;");
        mapString2Code.put("\u2009", "&thinsp;");
        mapString2Code.put("\u200c", "&zwnj;");
        mapString2Code.put("\u200d", "&zwj;");
        mapString2Code.put("\u200e", "&lrm;");
        mapString2Code.put("\u200f", "&rlm;");
        mapString2Code.put("\u2013", "&ndash;");
        mapString2Code.put("\u2014", "&mdash;");
        mapString2Code.put("\u2018", "&lsquo;");
        mapString2Code.put("\u2019", "&rsquo;");
        mapString2Code.put("\u201a", "&sbquo;");
        mapString2Code.put("\u201c", "&ldquo;");
        mapString2Code.put("\u201d", "&rdquo;");
        mapString2Code.put("\u201e", "&bdquo;");
        mapString2Code.put("\u2020", "&dagger;");
        mapString2Code.put("\u2021", "&Dagger;");
        mapString2Code.put("\u2030", "&permil;");
        mapString2Code.put("\u2039", "&lsaquo;");
        mapString2Code.put("\u203a", "&rsaquo;");
        mapString2Code.put("\u20ac", "&euro;");
        Iterator it = mapString2Code.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Object val = mapString2Code.get(key);
            mapCode2String.put(val, key);
        }
    }

    public static final String encode(String str) {
        if (str == null) {
            return null;
        }
        HtmlCodec.init();
        StringBuffer strbuf = new StringBuffer();
        char[] chArr = str.toCharArray();
        int len = str.length();
        int i = 0;
        while (i < len) {
            String strCode = (String)mapString2Code.get("" + chArr[i]);
            if (strCode == null) {
                strbuf.append(chArr[i]);
            } else {
                strbuf.append(strCode);
            }
            ++i;
        }
        return strbuf.toString();
    }

    public static final String decode(String str) {
        if (str == null) {
            return null;
        }
        HtmlCodec.init();
        StringBuffer strbuf = new StringBuffer();
        int index = 0;
        int startIndex = 0;
        int endIndex = 0;
        int len = str.length();
        while (index >= 0 && index < len) {
            startIndex = str.indexOf("&", index);
            if (startIndex >= 0) {
                strbuf.append(str.substring(index, startIndex));
                endIndex = str.indexOf(";", startIndex);
                if (endIndex > 0) {
                    String strCode = str.substring(startIndex, ++endIndex);
                    strCode = (String)mapCode2String.get(strCode);
                    strbuf.append(strCode);
                    index = endIndex;
                    continue;
                }
                strbuf.append(str.substring(startIndex));
                break;
            }
            strbuf.append(str.substring(index));
            break;
        }
        return strbuf.toString();
    }

    private static void testString(String str) {
        System.out.println(str);
        System.out.println(HtmlCodec.encode(str));
        System.out.println(HtmlCodec.decode(HtmlCodec.encode(str)));
        System.out.println();
    }

    private static void runTestAAA() {
        HtmlCodec.testString("Cats & Dogs");
        HtmlCodec.testString("& Dogs");
        HtmlCodec.testString("&");
        HtmlCodec.testString("");
        HtmlCodec.testString("cats &");
        HtmlCodec.testString("Nothing");
        HtmlCodec.testString("<test>");
        System.out.println(HtmlCodec.decode("Ramona's Caf&eacute;"));
    }

    public static void main(String[] argv) {
        HtmlCodec.runTestAAA();
    }
}

