/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.util.filter;

import edu.berkeley.guir.lib.util.filter.Filter;
import edu.berkeley.guir.lib.util.filter.FilterBaseImpl;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateFilter
extends FilterBaseImpl
implements Filter {
    public static final DateFormat DEFAULT_DATEFORMAT = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss z");
    Date dStart = null;
    Date dEnd = null;
    DateFormat dFormat = DEFAULT_DATEFORMAT;

    public DateFilter(Date start, Date end) {
        this(start, end, DEFAULT_DATEFORMAT);
    }

    public DateFilter(Date start, Date end, DateFormat df) {
        this.dStart = start;
        this.dEnd = end;
        this.dFormat = df;
    }

    public boolean isAccepted(Object obj) {
        Date d;
        if (obj instanceof String) {
            try {
                d = this.dFormat.parse((String)obj);
            }
            catch (Exception e) {
                ClassCastException newex = new ClassCastException("Not a date format: " + obj);
                throw newex;
            }
        } else {
            d = (Date)obj;
        }
        if (this.dStart != null && this.dEnd != null) {
            return d.after(this.dStart) && d.before(this.dEnd);
        }
        if (this.dStart != null && this.dEnd == null) {
            return d.after(this.dStart);
        }
        if (this.dStart == null && this.dEnd != null) {
            return d.before(this.dEnd);
        }
        return true;
    }
}

