/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.util.condition;

import edu.berkeley.guir.lib.util.TimeLib;
import edu.berkeley.guir.lib.util.condition.AndCondition;
import edu.berkeley.guir.lib.util.condition.Condition;
import edu.berkeley.guir.lib.util.condition.ConditionConstructor;
import edu.berkeley.guir.lib.util.condition.ConditionConstructorSingle;
import java.util.Calendar;
import java.util.Date;

public class TimeOfDayCondition
extends Condition {
    public static final ConditionConstructor CONSTRUCTOR = new SelfConstructor();
    public static final String NAME_START = "start";
    public static final String NAME_END = "end";
    String strTime = "12AM";
    int minuteOfDay = 0;

    public static Condition createBetweenCondition(String strAA, String strBB) {
        TimeOfDayCondition condAA = new TimeOfDayCondition(5, strAA);
        TimeOfDayCondition condBB = new TimeOfDayCondition(3, strBB);
        condAA.setName(NAME_START);
        condBB.setName(NAME_END);
        return new AndCondition(condAA, condBB);
    }

    public TimeOfDayCondition() {
    }

    public TimeOfDayCondition(int newRelation, String newTime) {
        this.setRelation(newRelation);
        this.setRelationValue(newTime);
    }

    public String getConditionType() {
        return CONSTRUCTOR.getType();
    }

    protected boolean isValidRelation(int newRelation) {
        switch (newRelation) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
            case 5: {
                return true;
            }
        }
        return false;
    }

    public void setRelationValue(String str) {
        this.minuteOfDay = TimeLib.timeToMinuteOfDay(str);
        this.strTime = str;
    }

    public String getRelationValue() {
        return this.strTime;
    }

    public boolean evaluate() {
        return this.evaluate(new Date());
    }

    public boolean evaluate(String strVal) {
        try {
            return this.evaluate(Condition.getDateFormat().parse(strVal));
        }
        catch (Exception e) {
            IllegalArgumentException ex = new IllegalArgumentException();
            ex.initCause(e);
            throw ex;
        }
    }

    public boolean evaluate(Date d) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        int hours = calendar.get(11);
        int minutes = calendar.get(12);
        return this.evaluate(60 * hours + minutes);
    }

    protected boolean evaluate(int aMinuteOfDay) {
        switch (this.getRelation()) {
            case 0: {
                return aMinuteOfDay == this.minuteOfDay;
            }
            case 1: {
                return aMinuteOfDay != this.minuteOfDay;
            }
            case 2: {
                return aMinuteOfDay < this.minuteOfDay;
            }
            case 3: {
                return aMinuteOfDay <= this.minuteOfDay;
            }
            case 4: {
                return aMinuteOfDay > this.minuteOfDay;
            }
            case 5: {
                return aMinuteOfDay >= this.minuteOfDay;
            }
        }
        throw new IllegalArgumentException("Unknown relation");
    }

    public static TimeOfDayCondition getTestInstanceAAA() {
        TimeOfDayCondition cond = new TimeOfDayCondition(2, "9AM");
        cond.setAttribute("name", "current-time");
        return cond;
    }

    public static TimeOfDayCondition getTestInstanceBBB() {
        return new TimeOfDayCondition(2, "2PM");
    }

    public static TimeOfDayCondition getTestInstanceCCC() {
        return new TimeOfDayCondition(4, "9AM");
    }

    public static TimeOfDayCondition getTestInstanceDDD() {
        return new TimeOfDayCondition(4, "2PM");
    }

    public static TimeOfDayCondition getTestInstanceEEE() {
        return new TimeOfDayCondition(2, "5PM");
    }

    private static void runBattery(Condition cond) {
        System.out.println("-------------");
        System.out.println(cond);
        System.out.println(cond.evaluate("2003.Feb.07 10:10:30 PDT"));
        System.out.println(cond.evaluate("2003.May.08 10:10:30 PDT"));
        System.out.println(cond.evaluate("2003.May.09 10:10:30 PDT"));
        System.out.println(cond.evaluate("2004.Feb.03 16:06:30 PST"));
        System.out.println("time: " + Condition.getDateFormat().format(new Date()));
        System.out.println(cond.evaluate(Condition.getDateFormat().format(new Date())));
    }

    private static void runTestAAA() {
        System.out.println(TimeOfDayCondition.getTestInstanceAAA());
        System.out.println(TimeOfDayCondition.getTestInstanceBBB());
        System.out.println(TimeOfDayCondition.getTestInstanceCCC());
        System.out.println(TimeOfDayCondition.getTestInstanceDDD());
    }

    private static void runTestBBB() {
        TimeOfDayCondition.runBattery(TimeOfDayCondition.getTestInstanceAAA());
        TimeOfDayCondition.runBattery(TimeOfDayCondition.getTestInstanceBBB());
        TimeOfDayCondition.runBattery(TimeOfDayCondition.getTestInstanceCCC());
        TimeOfDayCondition.runBattery(TimeOfDayCondition.getTestInstanceDDD());
    }

    private static void runTestCCC() {
        TimeOfDayCondition.runBattery(TimeOfDayCondition.getTestInstanceAAA());
        TimeOfDayCondition.runBattery(TimeOfDayCondition.getTestInstanceCCC());
        TimeOfDayCondition.runBattery(TimeOfDayCondition.getTestInstanceEEE());
        TimeOfDayCondition.runBattery(TimeOfDayCondition.createBetweenCondition("9AM", "5PM"));
        TimeOfDayCondition.runBattery(TimeOfDayCondition.createBetweenCondition("10AM", "5AM"));
        TimeOfDayCondition.runBattery(TimeOfDayCondition.createBetweenCondition("11AM", "12noon"));
    }

    private static void runTestDDD() throws Exception {
        Condition cond = TimeOfDayCondition.getTestInstanceAAA();
        cond.setName("NameAA");
        String str = cond.toString();
        System.out.println(str);
        System.out.println(cond.getClass());
        System.out.println("---------");
        cond = Condition.parse(str);
        str = cond.toString();
        System.out.println(str);
        System.out.println(cond.getClass());
        System.out.println("---------");
    }

    public static void main(String[] argv) throws Exception {
        Condition cond = new TimeOfDayCondition(4, "2PM");
        System.out.println(cond.evaluate("2003.May.08 10:10:30 PDT"));
        System.out.println(cond.evaluate("2003.May.09 10:10:30 PDT"));
        System.out.println(cond.evaluate("2004.Feb.03 16:06:30 PST"));
        cond = TimeOfDayCondition.createBetweenCondition("9AM", "5PM");
        System.out.println(cond.evaluate("2003.May.08 10:10:30 PDT"));
        System.out.println(cond.evaluate("2003.May.09 10:10:30 PDT"));
        System.out.println(cond.evaluate("2004.Feb.03 16:06:30 PST"));
    }

    static class SelfConstructor
    extends ConditionConstructorSingle {
        SelfConstructor() {
        }

        public Condition createInstance() {
            return new TimeOfDayCondition();
        }

        public String getType() {
            return "TimeOfDay";
        }
    }
}

