/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.util.condition;

import edu.berkeley.guir.lib.util.condition.Condition;
import edu.berkeley.guir.lib.util.condition.ConditionConstructor;
import edu.berkeley.guir.lib.util.condition.ConditionConstructorSingle;

public class StringCondition
extends Condition {
    public static final ConditionConstructor CONSTRUCTOR = new SelfConstructor();
    String strRelationVal;

    public StringCondition() {
    }

    public StringCondition(int newRelation, String newPattern) {
        this.setRelation(newRelation);
        this.setRelationValue(newPattern);
    }

    public String getConditionType() {
        return CONSTRUCTOR.getType();
    }

    protected boolean isValidRelation(int newRelation) {
        switch (newRelation) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
            case 5: {
                return true;
            }
            case 6: {
                return true;
            }
            case 7: {
                return true;
            }
        }
        return false;
    }

    public void setRelationValue(String str) {
        this.strRelationVal = str;
    }

    public String getRelationValue() {
        return this.strRelationVal;
    }

    public boolean evaluate(String strVal) {
        return this.evaluate(strVal, this.getRelationValue());
    }

    public boolean evaluate(String strAA, String strBB) {
        switch (this.relation) {
            case 0: {
                return this.compare(strAA, strBB) == 0;
            }
            case 1: {
                return this.compare(strAA, strBB) != 0;
            }
            case 2: {
                return this.compare(strAA, strBB) < 0;
            }
            case 3: {
                return this.compare(strAA, strBB) <= 0;
            }
            case 4: {
                return this.compare(strAA, strBB) > 0;
            }
            case 5: {
                return this.compare(strAA, strBB) >= 0;
            }
            case 6: {
                return StringCondition.simpleMatch(strAA, strBB);
            }
            case 7: {
                return strAA.matches(strBB);
            }
        }
        throw new IllegalArgumentException();
    }

    private final int compare(String strValAA, String strValBB) {
        return strValAA.compareTo(strValBB);
    }

    public static boolean simpleMatch(String str, String strPattern) {
        if (strPattern.startsWith("*")) {
            strPattern = strPattern.substring(1);
            return str.endsWith(strPattern);
        }
        if (strPattern.endsWith("*")) {
            strPattern = strPattern.substring(0, strPattern.length() - 1);
            return str.startsWith(strPattern);
        }
        return strPattern.equals(str);
    }

    public static Condition getTestInstanceAAA() {
        return new StringCondition(0, "abc");
    }

    public static Condition getTestInstanceBBB() {
        return new StringCondition(1, "abc");
    }

    public static Condition getTestInstanceCCC() {
        return new StringCondition(2, "abc");
    }

    public static Condition getTestInstanceDDD() {
        return new StringCondition(3, "abc");
    }

    public static Condition getTestInstanceEEE() {
        return new StringCondition(4, "abc");
    }

    public static Condition getTestInstanceFFF() {
        return new StringCondition(5, "abc");
    }

    public static Condition getTestInstanceGGG() {
        return new StringCondition(6, "abc*");
    }

    public static Condition getTestInstanceHHH() {
        return new StringCondition(6, "*abc");
    }

    public static Condition getTestInstanceIII() {
        return new StringCondition(7, "abc");
    }

    private static void runTestAAA() {
        System.out.println(StringCondition.getTestInstanceAAA().toXml());
        System.out.println(StringCondition.getTestInstanceBBB().toXml());
        System.out.println(StringCondition.getTestInstanceCCC().toXml());
        System.out.println(StringCondition.getTestInstanceDDD().toXml());
        System.out.println(StringCondition.getTestInstanceEEE().toXml());
        System.out.println(StringCondition.getTestInstanceFFF().toXml());
        System.out.println(StringCondition.getTestInstanceGGG().toXml());
        System.out.println(StringCondition.getTestInstanceHHH().toXml());
        System.out.println(StringCondition.getTestInstanceIII().toXml());
    }

    private static void runStringTests(Condition cond) {
        System.out.println("------------");
        System.out.println(cond);
        System.out.println(cond.evaluate("10"));
        System.out.println(cond.evaluate("abcdef"));
        System.out.println(cond.evaluate("abc"));
    }

    private static void runTestBBB() {
        StringCondition.runStringTests(StringCondition.getTestInstanceAAA());
        StringCondition.runStringTests(StringCondition.getTestInstanceBBB());
        StringCondition.runStringTests(StringCondition.getTestInstanceCCC());
        StringCondition.runStringTests(StringCondition.getTestInstanceDDD());
        StringCondition.runStringTests(StringCondition.getTestInstanceEEE());
        StringCondition.runStringTests(StringCondition.getTestInstanceFFF());
        StringCondition.runStringTests(StringCondition.getTestInstanceGGG());
        StringCondition.runStringTests(StringCondition.getTestInstanceHHH());
        StringCondition.runStringTests(StringCondition.getTestInstanceIII());
    }

    public static void main(String[] argv) {
        StringCondition.runTestAAA();
        StringCondition.runTestBBB();
    }

    static class SelfConstructor
    extends ConditionConstructorSingle {
        SelfConstructor() {
        }

        public Condition createInstance() {
            return new StringCondition();
        }

        public String getType() {
            return "String";
        }
    }
}

