/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.util.condition;

import edu.berkeley.guir.lib.util.condition.Condition;
import edu.berkeley.guir.lib.util.condition.ConditionConstructor;
import edu.berkeley.guir.lib.util.condition.ConditionConstructorSingle;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;

public class SetCondition
extends Condition {
    public static final ConditionConstructor CONSTRUCTOR = new SelfConstructor();
    Set setAccepted = new LinkedHashSet();

    public SetCondition() {
        this.setRelation(9);
    }

    public SetCondition(String strSet) {
        this();
        this.setRelationValue(strSet);
    }

    public SetCondition(String[] strArr) {
        this();
        int i = 0;
        while (i < strArr.length) {
            this.add(strArr[i]);
            ++i;
        }
    }

    public void add(String strVal) {
        this.setAccepted.add(strVal);
    }

    public String getConditionType() {
        return CONSTRUCTOR.getType();
    }

    protected boolean isValidRelation(int newRelation) {
        switch (newRelation) {
            case 9: {
                return true;
            }
        }
        return false;
    }

    public void setRelationValue(String strSet) {
        StringTokenizer strtok = new StringTokenizer(strSet, "[], ");
        while (strtok.hasMoreTokens()) {
            String str = strtok.nextToken();
            this.add(str);
        }
    }

    public String getRelationValue() {
        return this.setAccepted.toString();
    }

    public boolean evaluate(String strVal) {
        return this.setAccepted.contains(strVal);
    }

    public static Condition getTestInstanceAAA() {
        return new SetCondition("[a,b,c,d,e,f]");
    }

    public static Condition getTestInstanceBBB() {
        return new SetCondition("[9, 10, 11]");
    }

    private static void runTestAAA() {
        System.out.println(SetCondition.getTestInstanceAAA());
        System.out.println(SetCondition.getTestInstanceAAA().toXml());
        System.out.println();
        System.out.println(SetCondition.getTestInstanceBBB());
        System.out.println(SetCondition.getTestInstanceBBB().toXml());
    }

    private static void runTestBBB() {
        System.out.println(SetCondition.getTestInstanceAAA().toDebugString("a"));
        System.out.println(SetCondition.getTestInstanceAAA().toDebugString("e"));
        System.out.println(SetCondition.getTestInstanceAAA().toDebugString("10"));
        System.out.println(SetCondition.getTestInstanceBBB().toDebugString("a"));
        System.out.println(SetCondition.getTestInstanceBBB().toDebugString("e"));
        System.out.println(SetCondition.getTestInstanceBBB().toDebugString("10"));
    }

    public static void main(String[] argv) throws Exception {
        SetCondition.runTestAAA();
        SetCondition.runTestBBB();
    }

    static class SelfConstructor
    extends ConditionConstructorSingle {
        SelfConstructor() {
        }

        public Condition createInstance() {
            return new SetCondition();
        }

        public String getType() {
            return "Set";
        }
    }
}

