/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.util.condition;

import edu.berkeley.guir.lib.util.TimeLib;
import edu.berkeley.guir.lib.util.condition.Condition;
import edu.berkeley.guir.lib.util.condition.ConditionConstructor;
import edu.berkeley.guir.lib.util.condition.ConditionConstructorSingle;
import java.text.DateFormat;
import java.util.Date;

public class RelativeDateCondition
extends Condition {
    public static final ConditionConstructor CONSTRUCTOR = new SelfConstructor();
    public static final String ATTR_START_TIME = "start-time";
    DateFormat df = Condition.getDateFormat();
    long millis = 86400000L;
    String strTime = "1 day";

    public static Condition createRelativeDateFromNow(int relation, String strTime) {
        RelativeDateCondition cond = new RelativeDateCondition(relation, strTime);
        cond.touchStartTime();
        return cond;
    }

    public RelativeDateCondition() {
    }

    public RelativeDateCondition(int newRelation, String strRelTime) {
        this.setRelation(newRelation);
        this.setRelationValue(strRelTime);
    }

    public RelativeDateCondition(int newRelation, int millis) {
        this.setRelation(newRelation);
        this.setRelationValue(millis);
    }

    public void touchStartTime() {
        this.setAttribute(ATTR_START_TIME, Condition.getDateFormat().format(new Date()));
    }

    public String getConditionType() {
        return CONSTRUCTOR.getType();
    }

    protected boolean isValidRelation(int newRelation) {
        switch (newRelation) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
            case 5: {
                return true;
            }
        }
        return false;
    }

    public void setRelationValue(int newMillis) {
        this.millis = newMillis;
    }

    public void setRelationValue(String str) {
        try {
            this.millis = TimeLib.timespanToMillis(str);
            this.strTime = str;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getRelationValue() {
        return this.strTime;
    }

    public boolean evaluate() {
        return this.evaluate(this.getAttribute(ATTR_START_TIME));
    }

    public boolean evaluate(String strVal) {
        return this.evaluate(strVal, this.df);
    }

    public boolean evaluate(String strVal, DateFormat df) {
        try {
            return this.evaluate(df.parse(strVal));
        }
        catch (Exception e) {
            IllegalArgumentException ex = new IllegalArgumentException();
            ex.initCause(e);
            throw ex;
        }
    }

    public boolean evaluate(Date d) {
        long tAA = System.currentTimeMillis() - this.millis;
        long tBB = d.getTime();
        switch (this.relation) {
            case 0: {
                return tAA == tBB;
            }
            case 1: {
                return tAA != tBB;
            }
            case 2: {
                return tAA < tBB;
            }
            case 3: {
                return tAA <= tBB;
            }
            case 4: {
                return tAA > tBB;
            }
            case 5: {
                return tAA >= tBB;
            }
        }
        throw new IllegalArgumentException();
    }

    public static RelativeDateCondition getTestInstanceAAA() {
        return new RelativeDateCondition(2, "48 hours");
    }

    public static RelativeDateCondition getTestInstanceBBB() {
        return new RelativeDateCondition(2, "2 days");
    }

    public static RelativeDateCondition getTestInstanceCCC() {
        return new RelativeDateCondition(4, "1 month");
    }

    public static RelativeDateCondition getTestInstanceDDD() {
        return new RelativeDateCondition(4, "2 weeks");
    }

    public static Condition getTestInstanceEEE() {
        return RelativeDateCondition.createRelativeDateFromNow(4, "5 seconds");
    }

    public static Condition getTestInstanceFFF() {
        return RelativeDateCondition.createRelativeDateFromNow(2, "5 seconds");
    }

    public static Condition getTestInstanceGGG() {
        return RelativeDateCondition.createRelativeDateFromNow(2, "1200 seconds");
    }

    private static void runBattery(RelativeDateCondition cond) {
        System.out.println("-------------");
        System.out.println(cond);
        System.out.println(cond.evaluate("2003.Feb.07 10:10:30 PDT"));
        System.out.println(cond.evaluate("2003.May.08 10:10:30 PDT"));
        System.out.println(cond.evaluate("2003.May.09 10:10:30 PDT"));
    }

    private static void runTestAAA() {
        System.out.println(RelativeDateCondition.getTestInstanceAAA());
        System.out.println(RelativeDateCondition.getTestInstanceBBB());
        System.out.println(RelativeDateCondition.getTestInstanceCCC());
        System.out.println(RelativeDateCondition.getTestInstanceDDD());
    }

    private static void runTestBBB() {
        RelativeDateCondition.runBattery(RelativeDateCondition.getTestInstanceAAA());
        RelativeDateCondition.runBattery(RelativeDateCondition.getTestInstanceBBB());
        RelativeDateCondition.runBattery(RelativeDateCondition.getTestInstanceCCC());
        RelativeDateCondition.runBattery(RelativeDateCondition.getTestInstanceDDD());
    }

    private static void runExpiration(Condition cond) throws Exception {
        System.out.println(cond);
        System.out.println(cond.evaluate());
        Thread.sleep(2000L);
        System.out.println(cond.evaluate());
        Thread.sleep(2000L);
        System.out.println(cond.evaluate());
        Thread.sleep(2000L);
        System.out.println(cond.evaluate());
        Thread.sleep(2000L);
        System.out.println(cond.evaluate());
    }

    private static void runTestCCC() throws Exception {
        RelativeDateCondition.runExpiration(RelativeDateCondition.getTestInstanceEEE());
        RelativeDateCondition.runExpiration(RelativeDateCondition.getTestInstanceFFF());
        RelativeDateCondition.runExpiration(RelativeDateCondition.getTestInstanceGGG());
    }

    public static void main(String[] argv) throws Exception {
        RelativeDateCondition.runTestCCC();
    }

    static class SelfConstructor
    extends ConditionConstructorSingle {
        SelfConstructor() {
        }

        public Condition createInstance() {
            return new RelativeDateCondition();
        }

        public String getType() {
            return "RelDate";
        }
    }
}

