/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.util.condition;

import edu.berkeley.guir.lib.util.condition.AbsoluteDateCondition;
import edu.berkeley.guir.lib.util.condition.BooleanCondition;
import edu.berkeley.guir.lib.util.condition.Condition;
import edu.berkeley.guir.lib.util.condition.ConditionConstructor;
import edu.berkeley.guir.lib.util.condition.ConditionConstructorMulti;
import edu.berkeley.guir.lib.util.condition.MultiCondition;
import edu.berkeley.guir.lib.util.condition.SetCondition;
import java.util.Iterator;

public class OrCondition
extends MultiCondition {
    public static final ConditionConstructor CONSTRUCTOR = new SelfConstructor();

    public OrCondition() {
    }

    public OrCondition(Condition condAA) {
        super(condAA);
    }

    public OrCondition(Condition condAA, Condition condBB) {
        super(condAA, condBB);
    }

    public OrCondition(Condition condAA, Condition condBB, Condition condCC) {
        super(condAA, condBB, condCC);
    }

    public String getConditionType() {
        return CONSTRUCTOR.getType();
    }

    protected boolean isValidRelation(int newRelation) {
        return true;
    }

    public void setRelationValue(String str) {
        throw new IllegalArgumentException();
    }

    public String getRelationValue() {
        throw new IllegalArgumentException();
    }

    public boolean evaluate(String strVal) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Condition cond = (Condition)it.next();
            try {
                if (!cond.evaluate(strVal)) continue;
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean evaluate(String strValAA, String strValBB) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Condition cond = (Condition)it.next();
            try {
                if (!cond.evaluate(strValAA, strValBB)) continue;
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static Condition getTestInstanceAAA() {
        OrCondition condOr = new OrCondition();
        condOr.add(AbsoluteDateCondition.getTestInstanceAAA());
        condOr.add(BooleanCondition.getTestInstanceAAA());
        condOr.add(SetCondition.getTestInstanceAAA());
        return condOr;
    }

    public static Condition getTestInstanceBBB() {
        return null;
    }

    public static Condition getTestInstanceCCC() {
        return null;
    }

    public static Condition getTestInstanceDDD() {
        return null;
    }

    public static Condition getTestInstanceEEE() {
        return null;
    }

    public static Condition getTestInstanceFFF() {
        return null;
    }

    private static void runTestAAA() {
        System.out.println(OrCondition.getTestInstanceAAA());
    }

    private static void runTestBBB() {
        System.out.println(OrCondition.getTestInstanceAAA().evaluate("a"));
    }

    public static void main(String[] argv) {
        OrCondition.runTestBBB();
    }

    static class SelfConstructor
    extends ConditionConstructorMulti {
        SelfConstructor() {
        }

        public Condition createInstance() {
            return new OrCondition();
        }

        public String getType() {
            return "Or";
        }

        public boolean isMulti() {
            return true;
        }
    }
}

