/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.util.condition;

import edu.berkeley.guir.lib.collection.tuple.Tuple;
import edu.berkeley.guir.lib.util.condition.Condition;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class MultiCondition
extends Condition {
    List listConds = new LinkedList();

    public MultiCondition() {
    }

    public MultiCondition(Condition condAA) {
        this();
        this.add(condAA);
    }

    public MultiCondition(Condition condAA, Condition condBB) {
        this();
        this.add(condAA);
        this.add(condBB);
    }

    public MultiCondition(Condition condAA, Condition condBB, Condition condCC) {
        this();
        this.add(condAA);
        this.add(condBB);
        this.add(condCC);
    }

    public MultiCondition(Tuple t) {
    }

    public void add(Condition cond) {
        if (cond == null) {
            throw new IllegalArgumentException("Condition cannot be null");
        }
        this.listConds.add(cond);
    }

    public void remove(Condition cond) {
        this.listConds.remove(cond);
    }

    public void clear() {
        this.listConds.clear();
    }

    public List asList() {
        return new LinkedList(this.listConds);
    }

    public Iterator iterator() {
        return this.listConds.iterator();
    }

    public Condition getConditionByName(String strName) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Condition cond = (Condition)it.next();
            if (!strName.equals(cond.getName())) continue;
            return cond;
        }
        return null;
    }

    public void removeConditionByName(String strName) {
        Condition cond = this.getConditionByName(strName);
        if (cond != null) {
            this.listConds.remove(cond);
        }
    }

    public Tuple toTuple() {
        Tuple tRoot = super.toTuple();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Condition cond = (Condition)it.next();
            Tuple tCond = cond.toTuple();
            tRoot.addTuple(tCond);
        }
        return tRoot;
    }

    protected void toTupleHelper(Tuple t) {
    }

    public String toXml() {
        return this.toTuple().toXml(false);
    }

    public String toString() {
        return this.toXml();
    }
}

