/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.util.condition;

import edu.berkeley.guir.lib.util.condition.Condition;
import edu.berkeley.guir.lib.util.condition.ConditionConstructor;
import edu.berkeley.guir.lib.util.condition.ConditionConstructorSingle;

public class IntegerCondition
extends Condition {
    public static final ConditionConstructor CONSTRUCTOR = new SelfConstructor();
    int relationVal;

    public IntegerCondition() {
    }

    public IntegerCondition(int newRelation, int newVal) {
        this.setRelation(newRelation);
        this.setRelationValue(newVal);
    }

    public IntegerCondition(int newRelation, String newVal) {
        this.setRelation(newRelation);
        this.setRelationValue(newVal);
    }

    public String getConditionType() {
        return CONSTRUCTOR.getType();
    }

    protected boolean isValidRelation(int newRelation) {
        switch (newRelation) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
            case 5: {
                return true;
            }
        }
        return false;
    }

    public void setRelationValue(int newVal) {
        this.relationVal = newVal;
    }

    public void setRelationValue(String str) {
        try {
            this.relationVal = Integer.parseInt(str);
        }
        catch (Exception e) {
            IllegalArgumentException ex = new IllegalArgumentException();
            ex.initCause(e);
            throw ex;
        }
    }

    public String getRelationValue() {
        return "" + this.relationVal;
    }

    public boolean evaluate(String strVal) {
        try {
            return this.evaluate(Integer.parseInt(strVal));
        }
        catch (Exception e) {
            IllegalArgumentException ex = new IllegalArgumentException();
            ex.initCause(e);
            throw ex;
        }
    }

    public boolean evaluate(String strValAA, String strValBB) {
        try {
            return this.evaluate(Integer.parseInt(strValAA), Integer.parseInt(strValBB));
        }
        catch (Exception e) {
            IllegalArgumentException ex = new IllegalArgumentException();
            ex.initCause(e);
            throw ex;
        }
    }

    public boolean evaluate(int val) {
        return this.evaluate(val, this.relationVal);
    }

    public boolean evaluate(int valAA, int valBB) {
        switch (this.relation) {
            case 0: {
                return valAA == valBB;
            }
            case 1: {
                return valAA != valBB;
            }
            case 2: {
                return valAA < valBB;
            }
            case 3: {
                return valAA <= valBB;
            }
            case 4: {
                return valAA > valBB;
            }
            case 5: {
                return valAA >= valBB;
            }
        }
        throw new IllegalArgumentException();
    }

    public static Condition getTestInstanceAAA() {
        return new IntegerCondition(0, "10");
    }

    public static Condition getTestInstanceBBB() {
        return new IntegerCondition(1, "10");
    }

    public static Condition getTestInstanceCCC() {
        return new IntegerCondition(2, "10");
    }

    public static Condition getTestInstanceDDD() {
        return new IntegerCondition(3, 10);
    }

    public static Condition getTestInstanceEEE() {
        return new IntegerCondition(4, 10);
    }

    public static Condition getTestInstanceFFF() {
        return new IntegerCondition(5, 10);
    }

    private static void runTestAAA() {
        System.out.println(IntegerCondition.getTestInstanceAAA());
        System.out.println(IntegerCondition.getTestInstanceBBB());
        System.out.println(IntegerCondition.getTestInstanceCCC());
        System.out.println(IntegerCondition.getTestInstanceDDD());
        System.out.println(IntegerCondition.getTestInstanceEEE());
        System.out.println(IntegerCondition.getTestInstanceFFF());
    }

    private static void runTestBBB() {
        System.out.println(IntegerCondition.getTestInstanceAAA().toDebugString("10"));
        System.out.println(IntegerCondition.getTestInstanceBBB().toDebugString("10"));
        System.out.println(IntegerCondition.getTestInstanceCCC().toDebugString("10"));
        System.out.println(IntegerCondition.getTestInstanceDDD().toDebugString("10"));
        System.out.println(IntegerCondition.getTestInstanceEEE().toDebugString("10"));
        System.out.println(IntegerCondition.getTestInstanceFFF().toDebugString("10"));
    }

    public static void main(String[] argv) {
        IntegerCondition.runTestAAA();
        IntegerCondition.runTestBBB();
    }

    static class SelfConstructor
    extends ConditionConstructorSingle {
        SelfConstructor() {
        }

        public Condition createInstance() {
            return new IntegerCondition();
        }

        public String getType() {
            return "Integer";
        }
    }
}

