/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.util.condition;

import edu.berkeley.guir.lib.util.condition.Condition;
import edu.berkeley.guir.lib.util.condition.ConditionConstructor;
import edu.berkeley.guir.lib.util.condition.ConditionConstructorSingle;

public class DoubleCondition
extends Condition {
    public static final ConditionConstructor CONSTRUCTOR = new SelfConstructor();
    double relationVal;

    public DoubleCondition() {
    }

    public DoubleCondition(int newRelation, double newVal) {
        this.setRelation(newRelation);
        this.setRelationValue(newVal);
    }

    public DoubleCondition(int newRelation, String newVal) {
        this.setRelation(newRelation);
        this.setRelationValue(newVal);
    }

    public String getConditionType() {
        return CONSTRUCTOR.getType();
    }

    protected boolean isValidRelation(int newRelation) {
        switch (newRelation) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
            case 5: {
                return true;
            }
        }
        return false;
    }

    public void setRelationValue(double newVal) {
        this.relationVal = newVal;
    }

    public void setRelationValue(String str) {
        try {
            this.relationVal = Double.parseDouble(str);
        }
        catch (Exception e) {
            IllegalArgumentException ex = new IllegalArgumentException();
            ex.initCause(e);
            throw ex;
        }
    }

    public String getRelationValue() {
        return "" + this.relationVal;
    }

    public boolean evaluate(String strVal) {
        try {
            return this.evaluate(Double.parseDouble(strVal));
        }
        catch (Exception e) {
            IllegalArgumentException ex = new IllegalArgumentException();
            ex.initCause(e);
            throw ex;
        }
    }

    public boolean evaluate(String strValAA, String strValBB) {
        try {
            return this.evaluate(Double.parseDouble(strValAA), Double.parseDouble(strValBB));
        }
        catch (Exception e) {
            IllegalArgumentException ex = new IllegalArgumentException();
            ex.initCause(e);
            throw ex;
        }
    }

    public boolean evaluate(double val) {
        return this.evaluate(val, this.relationVal);
    }

    public boolean evaluate(double valAA, double valBB) {
        switch (this.relation) {
            case 0: {
                return valAA == valBB;
            }
            case 1: {
                return valAA != valBB;
            }
            case 2: {
                return valAA < valBB;
            }
            case 3: {
                return valAA <= valBB;
            }
            case 4: {
                return valAA > valBB;
            }
            case 5: {
                return valAA >= valBB;
            }
        }
        throw new IllegalArgumentException();
    }

    public static Condition getTestInstanceAAA() {
        return new DoubleCondition(0, 10.1);
    }

    public static Condition getTestInstanceBBB() {
        return new DoubleCondition(1, 10.1);
    }

    public static Condition getTestInstanceCCC() {
        return new DoubleCondition(2, 10.1);
    }

    public static Condition getTestInstanceDDD() {
        return new DoubleCondition(3, 10.1);
    }

    public static Condition getTestInstanceEEE() {
        return new DoubleCondition(4, 10.1);
    }

    public static Condition getTestInstanceFFF() {
        return new DoubleCondition(5, 10.1);
    }

    private static void runTestAAA() {
        System.out.println(DoubleCondition.getTestInstanceAAA());
        System.out.println(DoubleCondition.getTestInstanceBBB());
        System.out.println(DoubleCondition.getTestInstanceCCC());
        System.out.println(DoubleCondition.getTestInstanceDDD());
        System.out.println(DoubleCondition.getTestInstanceEEE());
        System.out.println(DoubleCondition.getTestInstanceFFF());
    }

    private static void runTestBBB() {
        System.out.println(DoubleCondition.getTestInstanceAAA().evaluate("2"));
        System.out.println(DoubleCondition.getTestInstanceBBB().evaluate("2"));
        System.out.println(DoubleCondition.getTestInstanceCCC().evaluate("2"));
        System.out.println(DoubleCondition.getTestInstanceDDD().evaluate("2"));
        System.out.println(DoubleCondition.getTestInstanceEEE().evaluate("2"));
        System.out.println(DoubleCondition.getTestInstanceFFF().evaluate("2"));
    }

    public static void main(String[] argv) {
        DoubleCondition.runTestAAA();
        DoubleCondition.runTestBBB();
    }

    static class SelfConstructor
    extends ConditionConstructorSingle {
        SelfConstructor() {
        }

        public Condition createInstance() {
            return new DoubleCondition();
        }

        public String getType() {
            return "Double";
        }
    }
}

