/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.util.condition;

import edu.berkeley.guir.lib.util.DayOfWeekLib;
import edu.berkeley.guir.lib.util.StringLib;
import edu.berkeley.guir.lib.util.condition.Condition;
import edu.berkeley.guir.lib.util.condition.ConditionConstructor;
import edu.berkeley.guir.lib.util.condition.ConditionConstructorSingle;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;

public class DayOfWeekCondition
extends Condition {
    public static final ConditionConstructor CONSTRUCTOR = new SelfConstructor();
    public static final String SUNDAY = "sun";
    public static final String MONDAY = "mon";
    public static final String TUESDAY = "tue";
    public static final String WEDNESDAY = "wed";
    public static final String THURSDAY = "thu";
    public static final String FRIDAY = "fri";
    public static final String SATURDAY = "sat";
    public static String[] ARRAY_VALID_DAYS = new String[]{"sun", "mon", "tue", "wed", "thu", "fri", "sat"};
    public static Set SET_VALID_DAYS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(ARRAY_VALID_DAYS)));
    public static final String[] ARRAY_WEEKDAYS = DayOfWeekLib.ARRAY_WEEKDAYS;
    public static final String[] ARRAY_WEEKEND = DayOfWeekLib.ARRAY_WEEKEND;
    Set setDays = new LinkedHashSet();

    public DayOfWeekCondition() {
        this.setRelation(9);
    }

    public DayOfWeekCondition(String strSet) {
        this();
        this.setRelationValue(strSet);
    }

    public DayOfWeekCondition(String[] strArrDays) {
        this();
        int i = 0;
        while (i < strArrDays.length) {
            this.add(strArrDays[i]);
            ++i;
        }
    }

    public void add(String strVal) {
        if ((strVal = strVal.toLowerCase()).length() > 3) {
            strVal = strVal.substring(0, 3);
        }
        if (!SET_VALID_DAYS.contains(strVal)) {
            throw new IllegalArgumentException();
        }
        this.setDays.add(strVal);
    }

    public String getConditionType() {
        return CONSTRUCTOR.getType();
    }

    protected boolean isValidRelation(int newRelation) {
        switch (newRelation) {
            case 9: {
                return true;
            }
        }
        return false;
    }

    public void setRelationValue(String strSet) {
        StringTokenizer strtok = new StringTokenizer(strSet, "[], ");
        while (strtok.hasMoreTokens()) {
            String str = strtok.nextToken();
            this.add(str);
        }
    }

    public String getRelationValue() {
        return this.setDays.toString();
    }

    public String[] getRelationValueAsStringArray() {
        String[] strArr = this.setDays.toArray(new String[0]);
        return strArr;
    }

    public int[] getRelationValueAsIntArray() {
        String[] strArr = this.getRelationValueAsStringArray();
        return DayOfWeekLib.asIntArray(strArr);
    }

    public boolean evaluate() {
        return this.evaluate(new Date());
    }

    public boolean evaluate(String strVal) {
        try {
            return this.evaluate(Condition.getDateFormat().parse(strVal));
        }
        catch (Exception e) {
            IllegalArgumentException ex = new IllegalArgumentException();
            ex.initCause(e);
            throw ex;
        }
    }

    public boolean evaluate(Date d) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        int dayOfWeek = calendar.get(7);
        switch (dayOfWeek) {
            case 1: {
                dayOfWeek = 0;
                break;
            }
            case 2: {
                dayOfWeek = 1;
                break;
            }
            case 3: {
                dayOfWeek = 2;
                break;
            }
            case 4: {
                dayOfWeek = 3;
                break;
            }
            case 5: {
                dayOfWeek = 4;
                break;
            }
            case 6: {
                dayOfWeek = 5;
                break;
            }
            case 7: {
                dayOfWeek = 6;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown day: " + dayOfWeek);
            }
        }
        String strDay = DayOfWeekLib.toShortDay(dayOfWeek).toLowerCase();
        return this.setDays.contains(strDay);
    }

    public static Condition getTestInstanceAAA() {
        DayOfWeekCondition cond = new DayOfWeekCondition();
        cond.add(SUNDAY);
        cond.add(MONDAY);
        return cond;
    }

    public static Condition getTestInstanceBBB() {
        DayOfWeekCondition cond = new DayOfWeekCondition();
        cond.add(SUNDAY);
        cond.add(MONDAY);
        cond.add(TUESDAY);
        cond.add(WEDNESDAY);
        cond.add(THURSDAY);
        cond.add(FRIDAY);
        cond.add(SATURDAY);
        return cond;
    }

    public static Condition getTestInstanceCCC() {
        DayOfWeekCondition cond = new DayOfWeekCondition();
        cond.add("SUNDAY");
        cond.add("MONDAY");
        cond.add("TUESDAY");
        cond.add("WEDNESDAY");
        cond.add("THURSDAY");
        cond.add("FRIDAY");
        cond.add("SATURDAY");
        return cond;
    }

    public static Condition getTestInstanceDDD() {
        DayOfWeekCondition cond = new DayOfWeekCondition();
        return cond;
    }

    private static void runTestAAA() {
        System.out.println(DayOfWeekCondition.getTestInstanceAAA());
        System.out.println(DayOfWeekCondition.getTestInstanceBBB());
        System.out.println(DayOfWeekCondition.getTestInstanceCCC());
    }

    private static void runTestBBB() throws Exception {
        Condition.printAndParse(DayOfWeekCondition.getTestInstanceAAA());
        Condition.printAndParse(DayOfWeekCondition.getTestInstanceBBB());
        Condition.printAndParse(DayOfWeekCondition.getTestInstanceCCC());
    }

    private static void runTestSuite(Condition cond) {
        System.out.println(cond.evaluate("2004.Feb.08 10:10:30 PDT"));
        System.out.println(cond.evaluate("2004.Feb.09 10:10:30 PDT"));
        System.out.println(cond.evaluate("2004.Feb.10 16:06:30 PST"));
        System.out.println(cond.evaluate("2004.Feb.11 16:06:30 PST"));
        System.out.println(cond.evaluate("2004.Feb.12 16:06:30 PST"));
        System.out.println(cond.evaluate("2004.Feb.13 16:06:30 PST"));
        System.out.println(cond.evaluate("2004.Feb.14 16:06:30 PST"));
        System.out.println(cond.evaluate());
        System.out.println("-----------------------");
    }

    private static void runTestCCC() {
        DayOfWeekCondition.runTestSuite(DayOfWeekCondition.getTestInstanceAAA());
        DayOfWeekCondition.runTestSuite(DayOfWeekCondition.getTestInstanceBBB());
        DayOfWeekCondition.runTestSuite(DayOfWeekCondition.getTestInstanceCCC());
    }

    private static void runTestDDD() {
        DayOfWeekCondition cond = new DayOfWeekCondition(ARRAY_WEEKDAYS);
        System.out.println(((Condition)cond).evaluate("2004.Feb.08 10:10:30 PDT"));
        System.out.println(((Condition)cond).evaluate("2004.Feb.09 10:10:30 PDT"));
        System.out.println(((Condition)cond).evaluate("2004.Feb.10 16:06:30 PST"));
        System.out.println(((Condition)cond).evaluate("2004.Feb.11 16:06:30 PST"));
        System.out.println(((Condition)cond).evaluate("2004.Feb.12 16:06:30 PST"));
        System.out.println(((Condition)cond).evaluate("2004.Feb.13 16:06:30 PST"));
        System.out.println(((Condition)cond).evaluate("2004.Feb.14 16:06:30 PST"));
        System.out.println(((Condition)cond).evaluate());
        System.out.println("-----------------------");
        cond = new DayOfWeekCondition(new String[]{MONDAY, WEDNESDAY, FRIDAY});
        System.out.println(((Condition)cond).evaluate("2004.Feb.08 10:10:30 PDT"));
        System.out.println(((Condition)cond).evaluate("2004.Feb.09 10:10:30 PDT"));
        System.out.println(((Condition)cond).evaluate("2004.Feb.10 16:06:30 PST"));
        System.out.println(((Condition)cond).evaluate("2004.Feb.11 16:06:30 PST"));
        System.out.println(((Condition)cond).evaluate("2004.Feb.12 16:06:30 PST"));
        System.out.println(((Condition)cond).evaluate("2004.Feb.13 16:06:30 PST"));
        System.out.println(((Condition)cond).evaluate("2004.Feb.14 16:06:30 PST"));
        System.out.println(((Condition)cond).evaluate());
        System.out.println("-----------------------");
    }

    private static void testAsArray(DayOfWeekCondition cond) {
        System.out.println(StringLib.toString(cond.getRelationValueAsStringArray()));
        System.out.println(StringLib.toString(cond.getRelationValueAsIntArray()));
        System.out.println("---------------");
    }

    private static void runTestEEE() {
        DayOfWeekCondition.testAsArray((DayOfWeekCondition)DayOfWeekCondition.getTestInstanceAAA());
        DayOfWeekCondition.testAsArray((DayOfWeekCondition)DayOfWeekCondition.getTestInstanceBBB());
        DayOfWeekCondition.testAsArray((DayOfWeekCondition)DayOfWeekCondition.getTestInstanceCCC());
        DayOfWeekCondition.testAsArray((DayOfWeekCondition)DayOfWeekCondition.getTestInstanceDDD());
    }

    public static void main(String[] argv) throws Exception {
        DayOfWeekCondition.runTestEEE();
    }

    static class SelfConstructor
    extends ConditionConstructorSingle {
        SelfConstructor() {
        }

        public Condition createInstance() {
            return new DayOfWeekCondition();
        }

        public String getType() {
            return "DayOfWeek";
        }
    }
}

