/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.util.condition;

import edu.berkeley.guir.lib.collection.tuple.Tuple;
import edu.berkeley.guir.lib.util.condition.Condition;
import edu.berkeley.guir.lib.util.condition.ConditionConstructor;
import java.util.Iterator;

public abstract class ConditionConstructorSingle
implements ConditionConstructor {
    static int parseRelation(String str) {
        int i = 0;
        while (i < Condition.RELATION_STR_ARR.length) {
            if (str.startsWith(Condition.RELATION_STR_ARR[i])) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException("Unknown relation");
    }

    public abstract Condition createInstance();

    public Condition createInstance(Tuple tCond) {
        Condition cond = this.createInstance();
        this.parseRelationAndValue(cond, tCond);
        this.copyAttributes(cond, tCond);
        return cond;
    }

    protected void parseRelationAndValue(Condition cond, Tuple tCond) {
        String strRelation = tCond.getAttribute("relation");
        cond.setRelation(ConditionConstructorSingle.parseRelation(strRelation));
        String strVal = tCond.getAttribute("value");
        cond.setRelationValue(strVal);
    }

    protected void copyAttributes(Condition cond, Tuple tCond) {
        Iterator it = tCond.attributeKeys();
        while (it.hasNext()) {
            String strKey = it.next().toString();
            if ("type".equals(strKey) || "value".equals(strKey)) continue;
            String strVal = tCond.getAttribute(strKey);
            cond.setAttribute(strKey, strVal);
        }
    }

    public boolean isMulti() {
        return false;
    }
}

