/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.util.condition;

import edu.berkeley.guir.lib.collection.tuple.Tuple;
import edu.berkeley.guir.lib.util.condition.AbsoluteDateCondition;
import edu.berkeley.guir.lib.util.condition.AndCondition;
import edu.berkeley.guir.lib.util.condition.BooleanCondition;
import edu.berkeley.guir.lib.util.condition.ConditionConstructor;
import edu.berkeley.guir.lib.util.condition.DayOfWeekCondition;
import edu.berkeley.guir.lib.util.condition.DoubleCondition;
import edu.berkeley.guir.lib.util.condition.IntegerCondition;
import edu.berkeley.guir.lib.util.condition.OrCondition;
import edu.berkeley.guir.lib.util.condition.RelativeDateCondition;
import edu.berkeley.guir.lib.util.condition.SetCondition;
import edu.berkeley.guir.lib.util.condition.StringCondition;
import edu.berkeley.guir.lib.util.condition.TimeOfDayCondition;
import edu.berkeley.guir.lib.xml.XmlParseException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class Condition {
    public static final int EQUAL = 0;
    public static final int NOT_EQUAL = 1;
    public static final int LESS_THAN = 2;
    public static final int LESS_THAN_OR_EQUAL = 3;
    public static final int GREATER_THAN = 4;
    public static final int GREATER_THAN_OR_EQUAL = 5;
    public static final int MATCHES = 6;
    public static final int REGEX = 7;
    public static final int SAME = 8;
    public static final int IN = 9;
    public static final String TUPLE_CONDITION = "Condition";
    public static final String COND_NAME = "name";
    public static final String COND_RELATION = "relation";
    public static final String COND_TYPE = "type";
    public static final String COND_VALUE = "value";
    static final Iterator EMPTY_ITERATOR = Collections.EMPTY_LIST.iterator();
    public static final String[] RELATION_STR_ARR = new String[]{".eq.", ".not.", ".lt.", ".lte.", ".gt.", ".gte.", ".matches.", ".regex.", ".same.", ".in."};
    public static final DateFormat DATEFORMAT = new SimpleDateFormat("yyyy.MMM.dd HH:mm:ss z");
    static boolean flagInit = false;
    static DateFormat dformat = DATEFORMAT;
    static Map mapCondTypes = new HashMap();
    int relation;
    String strRelationVal;
    Map mapAttributes;

    private static void init() {
        if (flagInit) {
            return;
        }
        flagInit = true;
        Condition.register(AbsoluteDateCondition.CONSTRUCTOR);
        Condition.register(BooleanCondition.CONSTRUCTOR);
        Condition.register(DoubleCondition.CONSTRUCTOR);
        Condition.register(IntegerCondition.CONSTRUCTOR);
        Condition.register(RelativeDateCondition.CONSTRUCTOR);
        Condition.register(SetCondition.CONSTRUCTOR);
        Condition.register(StringCondition.CONSTRUCTOR);
        Condition.register(TimeOfDayCondition.CONSTRUCTOR);
        Condition.register(DayOfWeekCondition.CONSTRUCTOR);
        Condition.register(AndCondition.CONSTRUCTOR);
        Condition.register(OrCondition.CONSTRUCTOR);
    }

    public static void toke() {
    }

    public static DateFormat getDateFormat() {
        return dformat;
    }

    public static void setDateFormat(DateFormat aDateFormat) {
        dformat = aDateFormat;
    }

    public static void register(ConditionConstructor constructor) {
        Condition.init();
        mapCondTypes.put(constructor.getType(), constructor);
    }

    public static Condition parse(String strCondition) throws XmlParseException {
        try {
            Tuple t = Tuple.parse(strCondition);
            return Condition.parse(t);
        }
        catch (Exception e) {
            throw new XmlParseException(e);
        }
    }

    public static Condition parse(Tuple tCondition) {
        Condition.init();
        String strType = tCondition.getAttribute(COND_TYPE);
        if (strType == null) {
            throw new IllegalArgumentException("Attribute 'type' required");
        }
        ConditionConstructor constructor = (ConditionConstructor)mapCondTypes.get(strType);
        if (constructor == null) {
            throw new IllegalArgumentException("Unknown 'type'");
        }
        Condition cond = constructor.createInstance(tCondition);
        return cond;
    }

    public abstract String getConditionType();

    public void setName(String newName) {
        this.setAttribute(COND_NAME, newName);
    }

    public String getName() {
        return this.getAttribute(COND_NAME);
    }

    public void setRelation(int newRelation) {
        if (!this.isValidRelation(newRelation)) {
            throw new IllegalArgumentException("Invalid relation");
        }
        this.relation = newRelation;
    }

    public int getRelation() {
        return this.relation;
    }

    protected boolean isValidRelation(int newRelation) {
        return newRelation >= 0 && newRelation <= RELATION_STR_ARR.length;
    }

    public void setRelationValue(String newVal) {
        throw new UnsupportedOperationException("Not supported");
    }

    public void setRelationValue(int newVal) {
        throw new UnsupportedOperationException("Not supported");
    }

    public void setRelationValue(double newVal) {
        throw new UnsupportedOperationException("Not supported");
    }

    public void setRelationValue(boolean newVal) {
        throw new UnsupportedOperationException("Not supported");
    }

    public String getRelationValue() {
        throw new UnsupportedOperationException("Not supported");
    }

    public void setAttribute(String strKey, String strVal) {
        if (this.mapAttributes == null) {
            this.mapAttributes = new LinkedHashMap();
        }
        this.mapAttributes.put(strKey, strVal);
    }

    public String getAttribute(String strKey) {
        if (this.mapAttributes == null) {
            return null;
        }
        return (String)this.mapAttributes.get(strKey);
    }

    public Iterator attributeKeys() {
        if (this.mapAttributes == null) {
            return EMPTY_ITERATOR;
        }
        return this.mapAttributes.keySet().iterator();
    }

    public Iterator attributeValues() {
        if (this.mapAttributes == null) {
            return EMPTY_ITERATOR;
        }
        return this.mapAttributes.values().iterator();
    }

    public boolean evaluate() {
        throw new UnsupportedOperationException("Not supported");
    }

    public boolean evaluate(String strVal) {
        throw new UnsupportedOperationException("Not supported");
    }

    public boolean evaluate(String strValAA, String strValBB) {
        throw new UnsupportedOperationException("Not supported");
    }

    public boolean evaluate(String[] strArr) {
        throw new UnsupportedOperationException("Not supported");
    }

    public Tuple toTuple() {
        Tuple t = new Tuple(TUPLE_CONDITION);
        t.setAttribute(COND_TYPE, this.getConditionType());
        this.toTupleHelper(t);
        this.toTupleHelper(t);
        Iterator it = this.attributeKeys();
        while (it.hasNext()) {
            String strKey = it.next().toString();
            String strVal = this.getAttribute(strKey);
            t.setAttribute(strKey, strVal);
        }
        return t;
    }

    protected void toTupleHelper(Tuple t) {
        t.setAttribute(COND_RELATION, Condition.toString(this.getRelation()));
        t.setAttribute(COND_VALUE, this.getRelationValue());
    }

    public String toXml() {
        return this.toTuple().toXml(false);
    }

    public String toString() {
        return this.toXml();
    }

    public static String toString(int relation) {
        return RELATION_STR_ARR[relation];
    }

    public String toDebugString(String strVal) {
        return String.valueOf(strVal) + " " + this.toString() + " == " + this.evaluate(strVal);
    }

    public String toDebugString(String strValAA, String strValBB) {
        return String.valueOf(strValAA) + " " + Condition.toString(this.getRelation()) + " " + strValBB + " == " + this.evaluate(strValAA, strValBB);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Condition)) {
            return false;
        }
        Condition condAA = this;
        Condition condBB = (Condition)obj;
        String strXmlAA = condAA.toXml();
        String strXmlBB = condBB.toXml();
        return strXmlAA.equals(strXmlBB);
    }

    private static void runTestSuiteAAA(Condition condAA) throws Exception {
        String strXml = condAA.toXml();
        System.out.println("------------------------");
        System.out.println(strXml);
        Condition condBB = Condition.parse(strXml);
        System.out.println(condBB.getClass());
        System.out.println(condBB.toXml());
        System.out.println(condBB.equals(condAA));
    }

    private static void testAAA() throws Exception {
        Condition.runTestSuiteAAA(AbsoluteDateCondition.getTestInstanceAAA());
        Condition.runTestSuiteAAA(AbsoluteDateCondition.getTestInstanceBBB());
        Condition.runTestSuiteAAA(BooleanCondition.getTestInstanceAAA());
        Condition.runTestSuiteAAA(BooleanCondition.getTestInstanceBBB());
        Condition.runTestSuiteAAA(DoubleCondition.getTestInstanceAAA());
        Condition.runTestSuiteAAA(DoubleCondition.getTestInstanceBBB());
        Condition.runTestSuiteAAA(IntegerCondition.getTestInstanceAAA());
        Condition.runTestSuiteAAA(IntegerCondition.getTestInstanceBBB());
        Condition.runTestSuiteAAA(RelativeDateCondition.getTestInstanceAAA());
        Condition.runTestSuiteAAA(RelativeDateCondition.getTestInstanceBBB());
        Condition.runTestSuiteAAA(SetCondition.getTestInstanceAAA());
        Condition.runTestSuiteAAA(SetCondition.getTestInstanceBBB());
        Condition.runTestSuiteAAA(StringCondition.getTestInstanceAAA());
        Condition.runTestSuiteAAA(StringCondition.getTestInstanceBBB());
        Condition.runTestSuiteAAA(AndCondition.getTestInstanceAAA());
        Condition.runTestSuiteAAA(OrCondition.getTestInstanceAAA());
    }

    private static void testBBB() throws Exception {
        System.out.println(AbsoluteDateCondition.getTestInstanceAAA().toXml());
        System.out.println(AbsoluteDateCondition.getTestInstanceBBB().toXml());
        System.out.println(BooleanCondition.getTestInstanceAAA().toXml());
        System.out.println(BooleanCondition.getTestInstanceBBB().toXml());
        System.out.println(DoubleCondition.getTestInstanceAAA().toXml());
        System.out.println(DoubleCondition.getTestInstanceBBB().toXml());
        System.out.println(IntegerCondition.getTestInstanceAAA().toXml());
        System.out.println(IntegerCondition.getTestInstanceBBB().toXml());
        System.out.println(RelativeDateCondition.getTestInstanceAAA().toXml());
        System.out.println(RelativeDateCondition.getTestInstanceBBB().toXml());
        System.out.println(SetCondition.getTestInstanceAAA().toXml());
        System.out.println(SetCondition.getTestInstanceBBB().toXml());
        System.out.println(StringCondition.getTestInstanceAAA().toXml());
        System.out.println(StringCondition.getTestInstanceBBB().toXml());
    }

    protected static void printAndParse(Condition condAA) throws Exception {
        String strAA = condAA.toString();
        System.out.println(strAA);
        Condition condBB = Condition.parse(strAA);
        String strBB = condBB.toString();
        System.out.println(strAA.equals(strBB));
        System.out.println("-----------------");
    }

    private static void testCCC() throws Exception {
        Condition.printAndParse(AbsoluteDateCondition.getTestInstanceAAA());
        Condition.printAndParse(AbsoluteDateCondition.getTestInstanceBBB());
        Condition.printAndParse(BooleanCondition.getTestInstanceAAA());
        Condition.printAndParse(BooleanCondition.getTestInstanceBBB());
        Condition.printAndParse(DoubleCondition.getTestInstanceAAA());
        Condition.printAndParse(DoubleCondition.getTestInstanceBBB());
        Condition.printAndParse(IntegerCondition.getTestInstanceAAA());
        Condition.printAndParse(IntegerCondition.getTestInstanceBBB());
        Condition.printAndParse(RelativeDateCondition.getTestInstanceAAA());
        Condition.printAndParse(RelativeDateCondition.getTestInstanceBBB());
        Condition.printAndParse(SetCondition.getTestInstanceAAA());
        Condition.printAndParse(SetCondition.getTestInstanceBBB());
        Condition.printAndParse(StringCondition.getTestInstanceAAA());
        Condition.printAndParse(StringCondition.getTestInstanceBBB());
        Condition.printAndParse(AndCondition.getTestInstanceAAA());
        Condition.printAndParse(OrCondition.getTestInstanceAAA());
    }

    public static void main(String[] argv) throws Exception {
        Condition.testCCC();
    }
}

