/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.util.condition;

import edu.berkeley.guir.lib.util.condition.Condition;
import edu.berkeley.guir.lib.util.condition.ConditionConstructor;
import edu.berkeley.guir.lib.util.condition.ConditionConstructorSingle;

public class BooleanCondition
extends Condition {
    public static final ConditionConstructor CONSTRUCTOR = new SelfConstructor();
    boolean relationVal = true;

    private static boolean parseBoolean(String str) {
        return "true".equalsIgnoreCase(str);
    }

    public BooleanCondition() {
    }

    public BooleanCondition(int newRelation, boolean newVal) {
        this.setRelation(newRelation);
        this.setRelationValue(newVal);
    }

    public BooleanCondition(int newRelation, String newVal) {
        this.setRelation(newRelation);
        this.setRelationValue(newVal);
    }

    public String getConditionType() {
        return CONSTRUCTOR.getType();
    }

    protected boolean isValidRelation(int newRelation) {
        switch (newRelation) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    public void setRelationValue(boolean newVal) {
        this.relationVal = newVal;
        this.strRelationVal = "" + newVal;
    }

    public void setRelationValue(String str) {
        this.relationVal = BooleanCondition.parseBoolean(str);
    }

    public String getRelationValue() {
        return "" + this.relationVal;
    }

    public boolean evaluate(String strVal) {
        return this.evaluate(BooleanCondition.parseBoolean(strVal));
    }

    public boolean evaluate(String strValAA, String strValBB) {
        return this.evaluate(BooleanCondition.parseBoolean(strValAA), BooleanCondition.parseBoolean(strValBB));
    }

    public boolean evaluate(boolean val) {
        return this.evaluate(val, this.relationVal);
    }

    public boolean evaluate(boolean valAA, boolean valBB) {
        switch (this.relation) {
            case 0: {
                return valAA == valBB;
            }
            case 1: {
                return valAA != valBB;
            }
        }
        throw new IllegalArgumentException();
    }

    public static Condition getTestInstanceAAA() {
        return new BooleanCondition(0, true);
    }

    public static Condition getTestInstanceBBB() {
        return new BooleanCondition(1, true);
    }

    public static Condition getTestInstanceCCC() {
        return new BooleanCondition(0, false);
    }

    public static Condition getTestInstanceDDD() {
        return new BooleanCondition(1, false);
    }

    private static void runTestAAA() {
        System.out.println(BooleanCondition.getTestInstanceAAA().toXml());
        System.out.println(BooleanCondition.getTestInstanceBBB().toXml());
        System.out.println(BooleanCondition.getTestInstanceCCC().toXml());
        System.out.println(BooleanCondition.getTestInstanceDDD().toXml());
    }

    private static void runTestBBB() {
        System.out.println(BooleanCondition.getTestInstanceAAA().evaluate("true"));
        System.out.println(BooleanCondition.getTestInstanceBBB().evaluate("true"));
        System.out.println(BooleanCondition.getTestInstanceCCC().evaluate("true"));
        System.out.println(BooleanCondition.getTestInstanceDDD().evaluate("true"));
        System.out.println();
        System.out.println(BooleanCondition.getTestInstanceAAA().evaluate("false"));
        System.out.println(BooleanCondition.getTestInstanceBBB().evaluate("false"));
        System.out.println(BooleanCondition.getTestInstanceCCC().evaluate("false"));
        System.out.println(BooleanCondition.getTestInstanceDDD().evaluate("false"));
    }

    public static void main(String[] argv) {
        BooleanCondition.runTestAAA();
        BooleanCondition.runTestBBB();
    }

    static class SelfConstructor
    extends ConditionConstructorSingle {
        SelfConstructor() {
        }

        public Condition createInstance() {
            return new BooleanCondition();
        }

        public String getType() {
            return "Boolean";
        }
    }
}

